/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.EntityEasel;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.packets.CanvasMiniUpdatePacket;

public class CanvasMiniUpdatePacketHandler {
    public static void handle(CanvasMiniUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when CanvasUpdatePacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> CanvasMiniUpdatePacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(CanvasMiniUpdatePacket msg, ServerPlayer pl) {
        ItemStack canvas;
        Entity entityEasel = null;
        if (msg.getEaselId() > -1) {
            entityEasel = pl.m_9236_().m_6815_(msg.getEaselId());
            if (entityEasel == null) {
                XercaPaint.LOGGER.error("CanvasMiniUpdatePacket: Easel entity not found! easelId: " + msg.getEaselId());
                return;
            }
            if (!(entityEasel instanceof EntityEasel)) {
                XercaPaint.LOGGER.error("CanvasMiniUpdatePacket: Entity found is not an easel! easelId: " + msg.getEaselId());
                return;
            }
            EntityEasel easel = (EntityEasel)entityEasel;
            canvas = easel.getItem();
            if (!(canvas.m_41720_() instanceof ItemCanvas)) {
                XercaPaint.LOGGER.error("CanvasMiniUpdatePacket: Canvas not found inside easel!");
                return;
            }
        } else {
            canvas = pl.m_21205_();
            ItemStack palette = pl.m_21206_();
            if (canvas.m_41720_() instanceof ItemPalette) {
                canvas = palette;
            }
        }
        if (!canvas.m_41619_() && canvas.m_41720_() instanceof ItemCanvas) {
            CompoundTag comp = canvas.m_41784_();
            comp.m_128385_("pixels", msg.getPixels());
            comp.m_128359_("name", msg.getName());
            comp.m_128405_("v", msg.getVersion());
            comp.m_128405_("generation", 0);
            if (entityEasel instanceof EntityEasel) {
                EntityEasel easel = (EntityEasel)entityEasel;
                easel.setItem(canvas, false);
            }
            XercaPaint.LOGGER.debug("Handling canvas update: Name: " + msg.getName() + " V: " + msg.getVersion());
        }
    }
}

