/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.itemlayers;

import com.google.common.collect.Maps;
import com.minecraftserverzone.lac.models.AbstractLACModel;
import com.minecraftserverzone.weaponmaster.WeaponMasterMod;
import com.minecraftserverzone.weaponmaster.itemlayers.HumanoidItemLayer;
import com.minecraftserverzone.weaponmaster.renderer.quiver.QuiverWithArrowsModel;
import com.minecraftserverzone.weaponmaster.setup.helper.ModUtils;
import com.minecraftserverzone.weaponmaster.setup.helper.ServerHelper;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.SpectralArrowRenderer;
import net.minecraft.client.renderer.entity.TippableArrowRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SpectralArrowItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class RenderHelper {
    public static final Map<String, QuiverWithArrowsModel<Player>> quiverModels = Maps.newHashMap();
    public static final Map<String, QuiverWithArrowsModel<Player>> arrowsModels = Maps.newHashMap();

    public static int[] uniqueSettings(ItemStack stack, int slotNumber, String txt) {
        String selectedSlotNumber = "0";
        if (slotNumber < 9) {
            selectedSlotNumber = String.valueOf(slotNumber + 1);
        } else if (slotNumber == 9) {
            selectedSlotNumber = "shield";
        } else if (slotNumber == 10) {
            selectedSlotNumber = "banner";
        } else if (slotNumber == 11) {
            selectedSlotNumber = "offhand";
        } else if (slotNumber == 12) {
            selectedSlotNumber = "quiver";
        }
        if (stack != null && stack.m_41720_() != null && ModUtils.stringContains(txt, ",")) {
            if (ModUtils.stringContains(txt, " ")) {
                String[] allData = txt.split(" ");
                for (int i = 0; i < allData.length; ++i) {
                    if (!ModUtils.stringContains(allData[i], ",")) continue;
                    String name = StringUtils.substringBefore((String)allData[i], (String)",");
                    String[] data = allData[i].split(",");
                    if (!ModUtils.arrayExist(data, 9) || stack.m_41720_().toString() == null || !stack.m_41720_().toString().equals(name) || !ModUtils.stringEquals(data[8], selectedSlotNumber)) continue;
                    return RenderHelper.getData(allData[i]);
                }
            } else {
                String name = StringUtils.substringBefore((String)txt, (String)",");
                String[] data = txt.split(",");
                if (ModUtils.arrayExist(data, 9) && stack.m_41720_().toString() != null && stack.m_41720_().toString().equals(name) && ModUtils.stringEquals(data[8], selectedSlotNumber)) {
                    return RenderHelper.getData(txt);
                }
            }
        }
        return new int[]{0, 0, 0, 0, 0, 0, 0};
    }

    public static int[] getData(String s) {
        String[] txtArray = s.split(",");
        if (ModUtils.arrayExist(txtArray, 8)) {
            int x = 0;
            if (NumberUtils.isCreatable((String)txtArray[1])) {
                x = NumberUtils.createInteger((String)txtArray[1]);
            }
            int y = 0;
            if (NumberUtils.isCreatable((String)txtArray[2])) {
                y = NumberUtils.createInteger((String)txtArray[2]);
            }
            int z = 0;
            if (NumberUtils.isCreatable((String)txtArray[3])) {
                z = NumberUtils.createInteger((String)txtArray[3]);
            }
            int xrot = 0;
            if (NumberUtils.isCreatable((String)txtArray[4])) {
                xrot = NumberUtils.createInteger((String)txtArray[4]);
            }
            int yrot = 0;
            if (NumberUtils.isCreatable((String)txtArray[5])) {
                yrot = NumberUtils.createInteger((String)txtArray[5]);
            }
            int zrot = 0;
            if (NumberUtils.isCreatable((String)txtArray[6])) {
                zrot = NumberUtils.createInteger((String)txtArray[6]);
            }
            int scale = 0;
            if (NumberUtils.isCreatable((String)txtArray[7])) {
                scale = NumberUtils.createInteger((String)txtArray[7]);
            }
            return new int[]{x, y, z, xrot, yrot, zrot, scale};
        }
        return new int[]{0, 0, 0, 0, 0, 0, 0};
    }

    public static boolean blackListed(ItemStack item, String txt) {
        if (txt != null) {
            String[] blacklist;
            if (item == null) {
                return false;
            }
            for (String bl : blacklist = txt.split(",")) {
                if (!item.m_41720_().toString().equals(bl)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean whiteListed(ItemStack item, String txt) {
        if (txt != null) {
            String[] whitelist;
            if (item == null) {
                return false;
            }
            for (String wl : whitelist = txt.split(",")) {
                if (!item.m_41720_().toString().equals(wl)) continue;
                return true;
            }
        }
        return false;
    }

    public static void move(PoseStack matrixStack, String[][] moveTypes, int slot, float translation) {
        if (moveTypes[slot][2].equals("-")) {
            translation = -translation;
        }
        if (moveTypes[slot][1].equals("x")) {
            matrixStack.m_252880_(translation, 0.0f, 0.0f);
        } else if (moveTypes[slot][1].equals("y")) {
            matrixStack.m_252880_(0.0f, translation, 0.0f);
        } else if (moveTypes[slot][1].equals("z")) {
            matrixStack.m_252880_(0.0f, 0.0f, translation);
        }
    }

    public static int hasItems(ItemStack[] items, Player player, String[][] moveTypes, int slot, int selected, int shieldSlot, int bannerSlot, int[] toggleSlots) {
        int j;
        int i = 0;
        for (j = 0; j < 9; ++j) {
            if (!moveTypes[slot][0].contains(String.valueOf(j + 1)) || items[j] == null || items[j].m_41619_() || selected == j || toggleSlots[j] != 1) continue;
            ++i;
        }
        if (moveTypes[slot][0].contains("shield") && shieldSlot > -1 && selected != shieldSlot && toggleSlots[9] == 1) {
            ++i;
        }
        if (moveTypes[slot][0].contains("banner") && bannerSlot > -1 && selected != bannerSlot && toggleSlots[10] == 1) {
            ++i;
        }
        if (moveTypes[slot][0].contains("quiver")) {
            for (j = 0; j < 9; ++j) {
                if (ServerHelper.getProjectile(player, items[j]) == null || !(ServerHelper.getProjectile(player, items[j]).m_41720_() instanceof ArrowItem) || items[j].m_41619_() || toggleSlots[10] != 1) continue;
                ++i;
                break;
            }
        }
        return i;
    }

    public static boolean hasEquipments(Player player, String[][] moveTypes, int slot) {
        boolean move = false;
        if (moveTypes[slot][0].contains("helm") && !player.m_150109_().m_36052_(3).m_41619_()) {
            move = true;
        }
        if (moveTypes[slot][0].contains("chest") && !player.m_150109_().m_36052_(2).m_41619_()) {
            move = true;
        }
        if (moveTypes[slot][0].contains("legs") && !player.m_150109_().m_36052_(1).m_41619_()) {
            move = true;
        }
        if (moveTypes[slot][0].contains("boots") && !player.m_150109_().m_36052_(0).m_41619_()) {
            move = true;
        }
        return move;
    }

    public static void translateToHand(ModelPart part, HumanoidArm p_102854_, PoseStack p_102855_) {
        part.m_104299_(p_102855_);
    }

    public static void translateAndRotate(PoseStack p_104300_, float x, float y, float z, float xRot, float yRot, float zRot, float xScale, float yScale, float zScale) {
        p_104300_.m_85837_((double)(x / 16.0f), (double)(y / 16.0f), (double)(z / 16.0f));
        if (zRot != 0.0f) {
            p_104300_.m_252781_(Axis.f_252403_.m_252961_(zRot));
        }
        if (yRot != 0.0f) {
            p_104300_.m_252781_(Axis.f_252436_.m_252961_(yRot));
        }
        if (xRot != 0.0f) {
            p_104300_.m_252781_(Axis.f_252529_.m_252961_(xRot));
        }
        if (xScale != 1.0f || yScale != 1.0f || zScale != 1.0f) {
            p_104300_.m_85841_(xScale, yScale, zScale);
        }
    }

    public static void copyModelPartRotation(HumanoidModel<LivingEntity> model, PoseStack ps, int slot, String[][] bodyattachment, float multiplier, float maxRotateChanger) {
        ModelPart part = model.f_102810_;
        if (bodyattachment[slot][1].equals("head")) {
            part = model.m_5585_();
        } else if (bodyattachment[slot][1].equals("body")) {
            part = model.f_102810_;
        } else if (bodyattachment[slot][1].equals("rarm")) {
            part = model.f_102811_;
        } else if (bodyattachment[slot][1].equals("larm")) {
            part = model.f_102812_;
        } else if (bodyattachment[slot][1].equals("rleg")) {
            part = model.f_102813_;
        } else if (bodyattachment[slot][1].equals("lleg")) {
            part = model.f_102814_;
        }
        part.m_104299_(ps);
    }

    public static ModelPart copyModelPartRotation(int modelType, AbstractLACModel parentmodel, PoseStack ps, int slot, String[][] bodyattachment, float multiplier, float maxRotateChanger) {
        ModelPart part = parentmodel.realBody();
        if (bodyattachment[slot][1].equals("head")) {
            part = parentmodel.head();
        } else if (bodyattachment[slot][1].equals("body")) {
            part = parentmodel.realBody();
        } else if (bodyattachment[slot][1].equals("rarm")) {
            part = parentmodel.rightArm();
        } else if (bodyattachment[slot][1].equals("larm")) {
            part = parentmodel.leftArm();
        } else if (bodyattachment[slot][1].equals("rleg")) {
            part = parentmodel.rightLeg();
        } else if (bodyattachment[slot][1].equals("lleg")) {
            part = parentmodel.leftLeg();
        }
        return part;
    }

    public static void renderTridentItem(int slot, LivingEntity player, ItemStack itemStack, PoseStack p_174521_, MultiBufferSource p_174522_, int p_174523_, ItemDisplayContext ctx) {
        p_174521_.m_85836_();
        p_174521_.m_252781_(Axis.f_252403_.m_252977_(140.0f));
        p_174521_.m_85837_((double)0.7f, 0.9, 0.61);
        p_174521_.m_85841_(0.9f, 0.9f, 0.9f);
        p_174521_.m_252880_(-0.45f, -1.07f, -0.535f);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(-60.0f));
        Minecraft.m_91087_().m_91290_().m_234586_().m_269530_(player, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.m_85849_();
    }

    public static void renderCrossbowItem(int slot, LivingEntity player, ItemStack itemStack, PoseStack p_174521_, MultiBufferSource p_174522_, int p_174523_, ItemDisplayContext ctx) {
        p_174521_.m_85836_();
        p_174521_.m_85837_(-0.05, 0.35, 0.16);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        p_174521_.m_252781_(Axis.f_252403_.m_252977_(270.0f));
        p_174521_.m_85841_(0.8f, -0.8f, -0.8f);
        p_174521_.m_252880_(0.1f, -0.2f, 0.0f);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(0.0f));
        p_174521_.m_252781_(Axis.f_252403_.m_252977_(60.0f));
        p_174521_.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        Minecraft.m_91087_().m_91290_().m_234586_().m_269530_(player, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.m_85849_();
    }

    public static void renderBowItem(int slot, LivingEntity player, ItemStack itemStack, PoseStack p_174521_, MultiBufferSource p_174522_, int p_174523_, ItemDisplayContext ctx) {
        p_174521_.m_85836_();
        p_174521_.m_85837_(0.0, 0.35, 0.16);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        p_174521_.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        p_174521_.m_85841_(0.8f, -0.8f, -0.8f);
        p_174521_.m_85837_(-0.05, 0.2, -0.07);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(97.0f));
        p_174521_.m_252781_(Axis.f_252403_.m_252977_(-6.0f));
        p_174521_.m_252781_(Axis.f_252529_.m_252977_(40.0f));
        Minecraft.m_91087_().m_91290_().m_234586_().m_269530_(player, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.m_85849_();
    }

    public static void renderNormalItem(int slot, LivingEntity player, ItemStack itemStack, PoseStack p_174521_, MultiBufferSource p_174522_, int p_174523_, ItemDisplayContext ctx) {
        p_174521_.m_85836_();
        p_174521_.m_85837_(0.0, 0.35, 0.16);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        p_174521_.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        p_174521_.m_85841_(0.8f, -0.8f, -0.8f);
        p_174521_.m_252880_(0.1f, -0.1f, -0.08f);
        Minecraft.m_91087_().m_91290_().m_234586_().m_269530_(player, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.m_85849_();
    }

    public static void renderTieredItem(int slot, LivingEntity player, ItemStack itemStack, PoseStack p_174521_, MultiBufferSource p_174522_, int p_174523_, ItemDisplayContext ctx) {
        p_174521_.m_85836_();
        p_174521_.m_85837_(-0.05, 0.3, 0.16);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        p_174521_.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        p_174521_.m_85841_(0.8f, -0.8f, -0.8f);
        p_174521_.m_85837_(-0.2, -0.1, -0.0);
        p_174521_.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        p_174521_.m_252781_(Axis.f_252529_.m_252977_(55.0f));
        Minecraft.m_91087_().m_91290_().m_234586_().m_269530_(player, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.m_85849_();
    }

    public static void renderOtherPlayerWithItems(Player player, PoseStack p_174521_, MultiBufferSource p_174522_, int p_174523_, HumanoidModel<LivingEntity> model) {
        float f;
        float scalePlus;
        float f2;
        float scalePlus2;
        int[] add;
        float moveBy;
        QuiverWithArrowsModel<Player> quiver = null;
        QuiverWithArrowsModel<Player> arrows = null;
        String playername = player.m_7755_().getString();
        if (!quiverModels.containsKey(playername)) {
            quiverModels.put(playername, new QuiverWithArrowsModel(QuiverWithArrowsModel.createBodyLayer().m_171564_()));
            quiver = quiverModels.get(playername);
        } else {
            quiver = quiverModels.get(playername);
        }
        if (!arrowsModels.containsKey(playername)) {
            arrowsModels.put(playername, new QuiverWithArrowsModel(QuiverWithArrowsModel.createArrowBodyLayer().m_171564_()));
            arrows = arrowsModels.get(playername);
        } else {
            arrows = arrowsModels.get(playername);
        }
        PlayerData data = ((IPlayerData)player).getPlayerData();
        String uniqueItemSettings = data.uniqueItemDisplay;
        String whitelist = data.whitelist;
        String[] moveSlots = data.mover.split("_");
        String[][] moveTypes = new String[][]{moveSlots[0].split(";"), moveSlots[1].split(";"), moveSlots[2].split(";"), moveSlots[3].split(";"), moveSlots[4].split(";"), moveSlots[5].split(";"), moveSlots[6].split(";"), moveSlots[7].split(";"), moveSlots[8].split(";"), moveSlots[9].split(";"), moveSlots[10].split(";"), moveSlots[11].split(";"), moveSlots[12].split(";")};
        int selected = data.selectedSlot;
        int num = 0;
        ItemStack stack1 = RenderHelper.blackListed(data.inventory[num], data.blacklist) ? ItemStack.f_41583_ : data.inventory[num];
        ItemStack stack2 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? ItemStack.f_41583_ : data.inventory[num];
        ItemStack stack3 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? ItemStack.f_41583_ : data.inventory[num];
        ItemStack stack4 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? ItemStack.f_41583_ : data.inventory[num];
        ItemStack stack5 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? ItemStack.f_41583_ : data.inventory[num];
        ItemStack stack6 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? ItemStack.f_41583_ : data.inventory[num];
        ItemStack stack7 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? ItemStack.f_41583_ : data.inventory[num];
        ItemStack stack8 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? ItemStack.f_41583_ : data.inventory[num];
        ItemStack stack9 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? ItemStack.f_41583_ : data.inventory[num];
        ItemStack offhand = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? ItemStack.f_41583_ : data.inventory[num];
        ItemStack ammo = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? ItemStack.f_41583_ : data.inventory[num];
        ItemStack[] items = new ItemStack[]{stack1, stack2, stack3, stack4, stack5, stack6, stack7, stack8, stack9, offhand, ammo};
        int[] toggleSlots = data.toggleSlots;
        int[] slotPositions = data.positions;
        int[] slotRotations = data.rotations;
        int[] scale = data.scale;
        String[] bodyattachments = data.slotAttachments.split(",");
        String[][] bodyattachment = new String[WeaponMasterMod.maxDisplaySlotNum][2];
        for (int i = 0; i < WeaponMasterMod.maxDisplaySlotNum; ++i) {
            bodyattachment[i][0] = bodyattachments[i].split("-")[0];
            bodyattachment[i][1] = bodyattachments[i].split("-")[1];
        }
        if (data.lastMainhandHit >= data.hideTick && data.toggleSlots[11] == 1) {
            selected = -1;
        }
        int shieldAt = -1;
        for (int i = 0; i < 9; ++i) {
            if (!(items[i].m_41720_() instanceof ShieldItem)) continue;
            shieldAt = i;
            break;
        }
        int bannerAt = -1;
        for (int i = 0; i < 9; ++i) {
            if (!(items[i].m_41720_() instanceof BannerItem)) continue;
            bannerAt = i;
            break;
        }
        if (bannerAt != -1 && selected != bannerAt && toggleSlots[10] == 1) {
            p_174521_.m_85836_();
            RenderHelper.copyModelPartRotation(model, p_174521_, 10, bodyattachment, 0.01f, 1.0f);
            float moveBy2 = (float)RenderHelper.hasItems(items, player, moveTypes, 10, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
            RenderHelper.move(p_174521_, moveTypes, 10, moveBy2);
            moveBy = RenderHelper.hasEquipments(player, moveTypes, 10) ? 0.038f : 0.0f;
            RenderHelper.move(p_174521_, moveTypes, 10, moveBy);
            add = RenderHelper.uniqueSettings(items[bannerAt], 10, uniqueItemSettings);
            p_174521_.m_252880_((float)(slotPositions[30] + add[0]) / 100.0f, (float)(slotPositions[31] + add[1]) / 100.0f, (float)(slotPositions[32] + add[2]) / 100.0f);
            p_174521_.m_252781_(Axis.f_252529_.m_252977_((float)(slotRotations[30] + add[3])));
            p_174521_.m_252781_(Axis.f_252436_.m_252977_((float)(slotRotations[31] + add[4])));
            p_174521_.m_252781_(Axis.f_252403_.m_252977_((float)(slotRotations[32] + add[5])));
            p_174521_.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            p_174521_.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            p_174521_.m_85837_(0.0, 0.6, -0.3);
            scalePlus2 = ((float)scale[10] + 0.001f + (float)add[6]) / 100.0f;
            f2 = 0.75f;
            p_174521_.m_85841_(f2 + scalePlus2, f2 + scalePlus2, f2 + scalePlus2);
            Minecraft.m_91087_().m_91290_().m_234586_().m_269530_((LivingEntity)player, items[bannerAt], ItemDisplayContext.NONE, false, p_174521_, p_174522_, p_174523_);
            p_174521_.m_85849_();
        }
        p_174521_.m_85836_();
        if (shieldAt != -1 && selected != shieldAt && toggleSlots[9] == 1) {
            p_174521_.m_85836_();
            RenderHelper.copyModelPartRotation(model, p_174521_, 9, bodyattachment, 1.0f, 1.0f);
            float moveBy2 = (float)RenderHelper.hasItems(items, player, moveTypes, 9, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
            RenderHelper.move(p_174521_, moveTypes, 9, moveBy2);
            moveBy = RenderHelper.hasEquipments(player, moveTypes, 9) ? 0.038f : 0.0f;
            RenderHelper.move(p_174521_, moveTypes, 9, moveBy);
            add = RenderHelper.uniqueSettings(items[shieldAt], 9, uniqueItemSettings);
            p_174521_.m_252880_((float)(slotPositions[27] + add[0]) / 100.0f, (float)(slotPositions[28] + add[1]) / 100.0f, (float)(slotPositions[29] + add[2]) / 100.0f);
            p_174521_.m_85837_(0.0, 0.0, 0.015);
            p_174521_.m_252781_(Axis.f_252529_.m_252977_((float)(slotRotations[27] + add[3])));
            p_174521_.m_252781_(Axis.f_252436_.m_252977_((float)(slotRotations[28] + add[4])));
            p_174521_.m_252781_(Axis.f_252403_.m_252977_((float)(slotRotations[29] + add[5])));
            p_174521_.m_85837_((double)0.3f, 0.7, 0.5);
            scalePlus2 = ((float)scale[9] + 0.001f + (float)add[6]) / 100.0f;
            f2 = 0.6f;
            p_174521_.m_85841_(f2 + scalePlus2, f2 + scalePlus2, f2 + scalePlus2);
            p_174521_.m_85837_(-0.25, -0.375, -0.625);
            p_174521_.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            Minecraft.m_91087_().m_91290_().m_234586_().m_269530_((LivingEntity)player, items[shieldAt], ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, p_174521_, p_174522_, p_174523_);
            p_174521_.m_85849_();
        }
        if (items != null && toggleSlots[13] == 1) {
            int size;
            boolean hasBowOrCrossbow = false;
            ItemStack projectile = new ItemStack((ItemLike)Items.f_41852_);
            if (ammo != null && ammo != ItemStack.f_41583_) {
                projectile = ammo;
                hasBowOrCrossbow = true;
            }
            if ((size = projectile.m_41613_()) > 0 && hasBowOrCrossbow) {
                p_174521_.m_85836_();
                RenderHelper.copyModelPartRotation(model, p_174521_, 12, bodyattachment, 1.0f, 1.0f);
                int[] add2 = new int[]{0, 0, 0, 0, 0, 0, 0};
                p_174521_.m_252880_((float)(slotPositions[36] + add2[0]) / 100.0f, (float)(slotPositions[37] + add2[1]) / 100.0f, (float)(slotPositions[38] + add2[2]) / 100.0f);
                float moveBy2 = (float)RenderHelper.hasItems(items, player, moveTypes, 12, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
                RenderHelper.move(p_174521_, moveTypes, 12, moveBy2);
                float moveByArmor = RenderHelper.hasEquipments(player, moveTypes, 12) ? 0.038f : 0.0f;
                RenderHelper.move(p_174521_, moveTypes, 12, moveByArmor);
                p_174521_.m_252781_(Axis.f_252529_.m_252977_((float)(slotRotations[36] + add2[3])));
                p_174521_.m_252781_(Axis.f_252436_.m_252977_((float)(slotRotations[37] + add2[4])));
                p_174521_.m_252781_(Axis.f_252403_.m_252977_((float)(slotRotations[38] + add2[5])));
                scalePlus = ((float)scale[12] + 0.001f + (float)add2[6]) / 100.0f;
                f = 0.5f;
                p_174521_.m_85841_(f + scalePlus, f + scalePlus, f + scalePlus);
                quiver.setupAnim(0, player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                ResourceLocation texture = HumanoidItemLayer.QUIVER;
                if (projectile.m_41720_() != null && projectile.m_41720_() != Items.f_41852_) {
                    if (projectile.m_41720_() instanceof SpectralArrowItem) {
                        arrow = SpectralArrowRenderer.f_115994_;
                        vertexConsumer = p_174522_.m_6299_(RenderType.m_110458_((ResourceLocation)arrow));
                        arrows.setupAnim(size, player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                        arrows.m_7695_(p_174521_, vertexConsumer, p_174523_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                    } else if (projectile.m_41720_() instanceof ArrowItem) {
                        arrow = TippableArrowRenderer.f_116132_;
                        vertexConsumer = p_174522_.m_6299_(RenderType.m_110458_((ResourceLocation)arrow));
                        arrows.setupAnim(size, player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                        arrows.m_7695_(p_174521_, vertexConsumer, p_174523_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                }
                VertexConsumer vertexConsumer = p_174522_.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
                quiver.m_7695_(p_174521_, vertexConsumer, p_174523_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                p_174521_.m_85849_();
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            boolean rightHanded;
            if (items[slot].m_41619_() || selected == slot || shieldAt == slot || bannerAt == slot || toggleSlots[slot] != 1) continue;
            p_174521_.m_85836_();
            RenderHelper.copyModelPartRotation(model, p_174521_, slot, bodyattachment, 1.0f, 1.0f);
            int[] add3 = RenderHelper.uniqueSettings(items[slot], slot, uniqueItemSettings);
            p_174521_.m_252880_((float)(slotPositions[slot * 3] + add3[0]) / 100.0f, (float)(slotPositions[slot * 3 + 1] + add3[1]) / 100.0f, (float)(slotPositions[slot * 3 + 2] + add3[2]) / 100.0f);
            float moveBy3 = (float)RenderHelper.hasItems(items, player, moveTypes, slot, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
            RenderHelper.move(p_174521_, moveTypes, slot, moveBy3);
            float moveByArmor = RenderHelper.hasEquipments(player, moveTypes, slot) ? 0.038f : 0.0f;
            RenderHelper.move(p_174521_, moveTypes, slot, moveByArmor);
            p_174521_.m_252781_(Axis.f_252529_.m_252977_((float)(slotRotations[slot * 3] + add3[3])));
            p_174521_.m_252781_(Axis.f_252436_.m_252977_((float)(slotRotations[slot * 3 + 1] + add3[4])));
            p_174521_.m_252781_(Axis.f_252403_.m_252977_((float)(slotRotations[slot * 3 + 2] + add3[5])));
            ItemDisplayContext ctx = ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
            boolean bl = rightHanded = player.m_5737_() == HumanoidArm.RIGHT;
            if (slot == 11) {
                ctx = rightHanded ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
            }
            scalePlus = ((float)scale[slot] + 0.001f + (float)add3[6]) / 100.0f;
            f = 1.0f;
            p_174521_.m_85841_(f + scalePlus, f + scalePlus, f + scalePlus);
            if (items[slot].m_41720_() instanceof BowItem) {
                RenderHelper.renderBowItem(slot, (LivingEntity)player, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            } else if (items[slot].m_41720_() instanceof CrossbowItem) {
                RenderHelper.renderCrossbowItem(slot, (LivingEntity)player, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            } else if (items[slot].m_41720_().getClass().equals(TridentItem.class)) {
                RenderHelper.renderTridentItem(slot, (LivingEntity)player, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            } else if ((items[slot].m_41720_() instanceof TieredItem || items[slot].m_41720_() instanceof Vanishable) && !(items[slot].m_41720_() instanceof Equipable)) {
                RenderHelper.renderTieredItem(slot, (LivingEntity)player, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            } else if (RenderHelper.whiteListed(items[slot], whitelist)) {
                p_174521_.m_85837_(0.0, 0.7, 0.0);
                p_174521_.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                RenderHelper.renderNormalItem(slot, (LivingEntity)player, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            }
            p_174521_.m_85849_();
        }
        int itemslot = 9;
        int slot = 11;
        if (!items[itemslot].m_41619_() && toggleSlots[slot + 1] == 1 && data.lastOffhandHit >= data.hideTick) {
            if (items[itemslot].m_41720_() != null && items[itemslot].m_41720_() instanceof ShieldItem) {
                p_174521_.m_85836_();
                RenderHelper.copyModelPartRotation(model, p_174521_, slot, bodyattachment, 1.0f, 1.0f);
                int[] add4 = RenderHelper.uniqueSettings(items[itemslot], 11, uniqueItemSettings);
                p_174521_.m_252880_((float)(slotPositions[slot * 3] + add4[0]) / 100.0f, (float)(slotPositions[slot * 3 + 1] + add4[1]) / 100.0f, (float)(slotPositions[slot * 3 + 2] + add4[2]) / 100.0f);
                float moveBy4 = (float)RenderHelper.hasItems(items, player, moveTypes, slot, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
                RenderHelper.move(p_174521_, moveTypes, slot, moveBy4);
                moveByArmor = RenderHelper.hasEquipments(player, moveTypes, slot) ? 0.038f : 0.0f;
                RenderHelper.move(p_174521_, moveTypes, slot, moveByArmor);
                p_174521_.m_252781_(Axis.f_252529_.m_252977_((float)(slotRotations[slot * 3] + add4[3])));
                p_174521_.m_252781_(Axis.f_252436_.m_252977_((float)(slotRotations[slot * 3 + 1] + add4[4])));
                p_174521_.m_252781_(Axis.f_252403_.m_252977_((float)(slotRotations[slot * 3 + 2] + add4[5])));
                ItemDisplayContext ctx = ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                p_174521_.m_85837_((double)0.3f, 0.35, 0.38);
                scalePlus = ((float)scale[slot] + 0.001f + (float)add4[6]) / 100.0f;
                f = 0.6f;
                p_174521_.m_85841_(f + scalePlus, f + scalePlus, f + scalePlus);
                p_174521_.m_85837_(-0.25, -0.375, -0.625);
                p_174521_.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                p_174521_.m_252781_(Axis.f_252529_.m_252977_(-35.0f));
                Minecraft.m_91087_().m_91290_().m_234586_().m_269530_((LivingEntity)player, items[itemslot], ctx, false, p_174521_, p_174522_, p_174523_);
                p_174521_.m_85849_();
            } else {
                p_174521_.m_85836_();
                RenderHelper.copyModelPartRotation(model, p_174521_, slot, bodyattachment, 1.0f, 1.0f);
                int[] add5 = RenderHelper.uniqueSettings(items[itemslot], 11, uniqueItemSettings);
                p_174521_.m_252880_((float)(slotPositions[slot * 3] + add5[0]) / 100.0f, (float)(slotPositions[slot * 3 + 1] + add5[1]) / 100.0f, (float)(slotPositions[slot * 3 + 2] + add5[2]) / 100.0f);
                float moveBy5 = (float)RenderHelper.hasItems(items, player, moveTypes, slot, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
                RenderHelper.move(p_174521_, moveTypes, slot, moveBy5);
                moveByArmor = RenderHelper.hasEquipments(player, moveTypes, slot) ? 0.038f : 0.0f;
                RenderHelper.move(p_174521_, moveTypes, slot, moveByArmor);
                p_174521_.m_252781_(Axis.f_252529_.m_252977_((float)slotRotations[slot * 3 + add5[3]]));
                p_174521_.m_252781_(Axis.f_252436_.m_252977_((float)(slotRotations[slot * 3 + 1] + add5[4])));
                p_174521_.m_252781_(Axis.f_252403_.m_252977_((float)(slotRotations[slot * 3 + 2] + add5[5])));
                ItemDisplayContext ctx = ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                scalePlus = ((float)scale[slot] + 0.001f + (float)add5[6]) / 100.0f;
                f = 1.0f;
                p_174521_.m_85841_(f + scalePlus, f + scalePlus, f + scalePlus);
                if (items[itemslot].m_41720_() instanceof BowItem) {
                    RenderHelper.renderBowItem(itemslot, (LivingEntity)player, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                } else if (items[itemslot].m_41720_() instanceof CrossbowItem) {
                    RenderHelper.renderCrossbowItem(itemslot, (LivingEntity)player, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                } else if (items[itemslot].m_41720_().getClass().equals(TridentItem.class)) {
                    RenderHelper.renderTridentItem(itemslot, (LivingEntity)player, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                } else if ((items[itemslot].m_41720_() instanceof TieredItem || items[itemslot].m_41720_() instanceof Vanishable) && !(items[itemslot].m_41720_() instanceof Equipable)) {
                    RenderHelper.renderTieredItem(itemslot, (LivingEntity)player, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                } else if (RenderHelper.whiteListed(items[itemslot], whitelist)) {
                    p_174521_.m_85837_(0.0, 0.7, 0.0);
                    p_174521_.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    RenderHelper.renderNormalItem(itemslot, (LivingEntity)player, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                }
                p_174521_.m_85849_();
            }
        }
        p_174521_.m_85849_();
    }
}

