/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.util;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class AquaticRarityColorHelper {
    private static final int AQUATIC_BLUE = 5745885;
    private static final int DEFAULT_COLOR = 0xAAAAAA;

    public static MutableComponent createSeaWaveGradient(String text) {
        MutableComponent result = Component.m_237113_((String)"");
        long currentTime = System.currentTimeMillis();
        float waveTime = (float)(currentTime % 3000L) / 3000.0f;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            float waterLevel = AquaticRarityColorHelper.getWaterLevel(i, length, waveTime);
            int color = AquaticRarityColorHelper.interpolateColor(5745885, 0xAAAAAA, waterLevel);
            result.m_7220_((Component)Component.m_237113_((String)String.valueOf(c)).m_6270_(Style.f_131099_.m_178520_(color)));
        }
        return result;
    }

    private static float getWaterLevel(float charIndex, int totalLength, float time) {
        float wave = AquaticRarityColorHelper.getWave(charIndex, totalLength, time);
        float baselineWaterLevel = 0.4f;
        float waveHeight = 0.35f;
        float waterLevel = baselineWaterLevel + wave * waveHeight;
        return Math.min(1.0f, Math.max(0.0f, waterLevel));
    }

    private static float getWave(float charIndex, int totalLength, float time) {
        float position = charIndex / (float)Math.max(1, totalLength - 1);
        float wavePhase = (position + time) % 1.0f;
        float wave = (float)(Math.sin((double)wavePhase * Math.PI * 2.0) * 0.5 + 0.5);
        wave = (float)Math.pow(wave, 1.8);
        return wave;
    }

    private static int interpolateColor(int color1, int color2, float ratio) {
        ratio = Math.max(0.0f, Math.min(1.0f, ratio));
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * ratio);
        int g = (int)((float)g1 + (float)(g2 - g1) * ratio);
        int b = (int)((float)b1 + (float)(b2 - b1) * ratio);
        return r << 16 | g << 8 | b;
    }
}

