/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.lightning;

import com.gametechbc.traveloptics.api.particle.JetFlamesParticleManager;
import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.entity.extended_projectiles.ExtendedWitherHomingMissileEntity;
import com.gametechbc.traveloptics.entity.misc.TOScreenShakeEntity;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.spells.TravelopticsSpellAnimations;
import com.github.L_Ender.cataclysm.entity.projectile.Laser_Beam_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class ArcaneArtillerySpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"traveloptics", (String)"arcane_artillery");
    private static final Vec3[] SPAWN_OFFSETS = new Vec3[]{new Vec3(0.0, 0.8, 0.0), new Vec3(-0.6, -0.4, 0.0), new Vec3(0.6, -0.4, 0.0)};
    private static final double SIDE_OFFSET = 0.72;
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.LIGHTNING_RESOURCE).setMaxLevel(10).setCooldownSeconds(12.0).build();
    private int currentLaserIndex = 0;

    public ArcaneArtillerySpell() {
        this.manaCostPerLevel = 2;
        this.baseSpellPower = 8;
        this.spellPowerPerLevel = 1;
        this.castTime = 100;
        this.baseManaCost = 10;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public AnimationHolder getCastStartAnimation() {
        return TravelopticsSpellAnimations.AQUA_MISSILES_LOOP;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        this.currentLaserIndex = 0;
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity caster, @Nullable MagicData playerMagicData) {
        ParticleOptions[] particleTypes = new ParticleOptions[]{ParticleTypes.f_175830_, ParticleTypes.f_123745_, ParticleTypes.f_175830_};
        int[] spawnPercentages = new int[]{40, 20, 40};
        JetFlamesParticleManager.createJetFlamesBelowDefaulted(caster.m_9236_(), (Entity)caster, particleTypes, spawnPercentages, 8, false);
        TOGeneralUtils.applyHovering((Entity)caster, 5.0, 0.2, 0.3, true);
        if (playerMagicData != null) {
            int castDuration = this.getCastTime(spellLevel);
            int ticksUsed = castDuration - playerMagicData.getCastDurationRemaining();
            if (ticksUsed % 3 == 0) {
                float damage = this.getDamage(spellLevel, caster);
                this.spawnLaserBeam(level, caster, damage, 1.5f);
                this.currentLaserIndex = (this.currentLaserIndex + 1) % 3;
            }
            if (ticksUsed % 15 == 0 && ticksUsed > 0) {
                Entity target = this.getRaycastTarget(level, caster, 48.0);
                this.spawnWitherMissiles(level, caster, spellLevel, target);
            }
            if (ticksUsed % 6 == 0) {
                TOScreenShakeEntity.createScreenShake(level, caster.m_20182_(), 8.0f, 0.008f, 4, 0, 2, false);
            }
        }
    }

    private void spawnLaserBeam(Level level, LivingEntity caster, float damage, float speed) {
        Vec3 offset = SPAWN_OFFSETS[this.currentLaserIndex];
        Vec3 lookVec = caster.m_20252_(1.0f).m_82541_();
        Vec3 baseSpawnPos = new Vec3(caster.m_20185_(), caster.m_20186_() + (double)(caster.m_20192_() * 0.8f), caster.m_20189_());
        Vec3 rightVector = lookVec.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        Vec3 upVector = rightVector.m_82537_(lookVec).m_82541_();
        Vec3 spawnPos = baseSpawnPos.m_82549_(rightVector.m_82490_(offset.f_82479_)).m_82549_(upVector.m_82490_(offset.f_82480_)).m_82549_(lookVec.m_82490_(1.5));
        double convergenceDistance = 20.0;
        Vec3 convergencePoint = caster.m_20299_(1.0f).m_82549_(lookVec.m_82490_(convergenceDistance));
        Vec3 adjustedDirection = convergencePoint.m_82546_(spawnPos).m_82541_();
        float yRot = (float)(Mth.m_14136_((double)adjustedDirection.f_82481_, (double)adjustedDirection.f_82479_) * 57.29577951308232) + 90.0f;
        float xRot = (float)(-(Mth.m_14136_((double)adjustedDirection.f_82480_, (double)Math.sqrt(adjustedDirection.f_82479_ * adjustedDirection.f_82479_ + adjustedDirection.f_82481_ * adjustedDirection.f_82481_)) * 57.29577951308232));
        Laser_Beam_Entity laserBeam = new Laser_Beam_Entity((EntityType)ModEntities.LASER_BEAM.get(), caster, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, adjustedDirection.f_82479_ * (double)speed, adjustedDirection.f_82480_ * (double)speed, adjustedDirection.f_82481_ * (double)speed, damage, level);
        laserBeam.m_146922_(yRot);
        laserBeam.m_146926_(xRot);
        level.m_7967_((Entity)laserBeam);
        level.m_5594_(null, caster.m_20183_(), (SoundEvent)TravelopticsSounds.LASER_SHOOT.get(), SoundSource.NEUTRAL, 0.6f, 1.0f);
    }

    private void spawnWitherMissiles(Level level, LivingEntity caster, int spellLevel, @Nullable Entity target) {
        if (target == null) {
            return;
        }
        float damage = this.getDamage(spellLevel, caster);
        Vec3[] sidePositions = this.calculateSideSpawnPositions(caster);
        this.spawnSingleWitherMissile(level, caster, sidePositions[0], damage, target);
        this.spawnSingleWitherMissile(level, caster, sidePositions[1], damage, target);
        TOScreenShakeEntity.createScreenShake(level, caster.m_20182_(), 8.0f, 0.008f, 8, 0, 5, false);
        level.m_5594_(null, caster.m_20183_(), (SoundEvent)ModSounds.ROCKET_LAUNCH.get(), SoundSource.NEUTRAL, 0.8f, 1.0f);
    }

    private Vec3[] calculateSideSpawnPositions(LivingEntity caster) {
        double offsetDirection = 0.72;
        double offsetXLeft = -offsetDirection * (double)Mth.m_14089_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
        double offsetZLeft = -offsetDirection * (double)Mth.m_14031_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
        double offsetXRight = offsetDirection * (double)Mth.m_14089_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
        double offsetZRight = offsetDirection * (double)Mth.m_14031_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
        Vec3 leftPos = new Vec3(caster.m_20185_() + offsetXLeft, caster.m_20188_() - (double)0.4f, caster.m_20189_() + offsetZLeft);
        Vec3 rightPos = new Vec3(caster.m_20185_() + offsetXRight, caster.m_20188_() - (double)0.4f, caster.m_20189_() + offsetZRight);
        return new Vec3[]{leftPos, rightPos};
    }

    private void spawnSingleWitherMissile(Level level, LivingEntity caster, Vec3 spawnPos, float damage, Entity target) {
        Vec3 velocity = target.m_20182_().m_82546_(caster.m_20182_()).m_82541_().m_82490_(0.5);
        ExtendedWitherHomingMissileEntity missile = new ExtendedWitherHomingMissileEntity(caster, velocity, level, 0.0f, (LivingEntity)target);
        missile.setExtendedHomingMissilesDamage(damage);
        missile.setShouldDealMagicDamage(true);
        missile.m_6027_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        level.m_7967_((Entity)missile);
    }

    private Entity getRaycastTarget(Level level, LivingEntity caster, double range) {
        Vec3 lookVec;
        Vec3 endPos;
        Vec3 eyePos = caster.m_20299_(1.0f);
        BlockHitResult blockHit = level.m_45547_(new ClipContext(eyePos, endPos = eyePos.m_82549_((lookVec = caster.m_20252_(1.0f)).m_82490_(range)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)caster));
        double actualRange = blockHit.m_6662_() != HitResult.Type.MISS ? eyePos.m_82554_(blockHit.m_82450_()) : range;
        Vec3 limitedEndPos = eyePos.m_82549_(lookVec.m_82490_(actualRange));
        AABB searchBox = new AABB(eyePos, limitedEndPos).m_82400_(0.5);
        List potentialTargets = level.m_6249_((Entity)caster, searchBox, entity -> entity instanceof LivingEntity && !entity.m_5833_() && entity.m_6084_());
        Entity closestEntity = null;
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity2 : potentialTargets) {
            BlockHitResult entityCheck;
            Vec3 toEntityNorm;
            double alignment;
            Vec3 toEntity = entity2.m_20191_().m_82399_().m_82546_(eyePos);
            double distance = toEntity.m_82553_();
            if (distance > actualRange || !((alignment = lookVec.m_82526_(toEntityNorm = toEntity.m_82541_())) >= 0.995) || (entityCheck = level.m_45547_(new ClipContext(eyePos, entity2.m_20191_().m_82399_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)caster))).m_6662_() != HitResult.Type.MISS && !(eyePos.m_82554_(entityCheck.m_82450_()) >= distance - 0.1) || !(distance < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity2;
        }
        return closestEntity;
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster);
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.none();
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1)}));
    }
}

