/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.eldritch;

import com.gametechbc.traveloptics.api.particle.ParticleDirection;
import com.gametechbc.traveloptics.api.particle.SphereParticleManager;
import com.gametechbc.traveloptics.data_manager.SoulApexManager;
import com.gametechbc.traveloptics.entity.misc.TOScreenShakeEntity;
import com.gametechbc.traveloptics.entity.misc.soul_apex.SoulApexEntity;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.spells.TravelopticsSpellAnimations;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

@AutoSpellConfig
public class ApexHarvestSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"traveloptics", (String)"apex_harvest");
    private static final Vector3f SOUL_COLOR = new Vector3f(0.1254902f, 0.70980394f, 0.58431375f);
    private static final int MAX_APEX_COLLECTION = 5;
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ELDRITCH_RESOURCE).setMaxLevel(1).setCooldownSeconds(10.0).build();

    public ApexHarvestSpell() {
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 0;
        this.spellPowerPerLevel = 0;
        this.castTime = 0;
        this.baseManaCost = 50;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public AnimationHolder getCastStartAnimation() {
        return TravelopticsSpellAnimations.SERPENTIDE_CAST;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.MALEDICTUS_BATTLE_CRY.get());
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        List<Item> allowedWeapons = List.of((Item)TravelopticsItems.CURSED_WRAITHBLADE.get(), (Item)TravelopticsItems.CURSED_WRAITHBLADE_LEVEL_ONE.get(), (Item)TravelopticsItems.CURSED_WRAITHBLADE_LEVEL_TWO.get(), (Item)TravelopticsItems.CURSED_WRAITHBLADE_LEVEL_THREE.get());
        if (allowedWeapons.contains(entity.m_21205_().m_41720_())) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.m_5776_()) {
                player.m_5661_((Component)Component.m_237115_((String)"spell.traveloptics.apex_harvest.warning").m_130940_(ChatFormatting.RED), true);
            }
        }
        return false;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack mainHandItem = player.m_21205_();
        AABB searchArea = new AABB(player.m_20182_(), player.m_20182_()).m_82400_(this.getCollectionRadius());
        List soulApexEntities = level.m_6443_(SoulApexEntity.class, searchArea, apex -> apex.isOwner(player));
        List<SoulApexEntity> closestApexes = soulApexEntities.stream().sorted(Comparator.comparingDouble(apex -> apex.m_20280_((Entity)player))).limit(5L).toList();
        this.spawnRageExplosion(level, player);
        this.spawnAmbientRadiusEffect(level, player);
        TOScreenShakeEntity.createScreenShake(level, player.m_20182_(), (float)this.getCollectionRadius(), 0.015f, 8, 3, 5, true);
        if (!closestApexes.isEmpty()) {
            SoulApexManager.addSoulApex(mainHandItem, player, closestApexes.size());
            for (SoulApexEntity apex2 : closestApexes) {
                this.spawnApexCollectionEffect(level, apex2);
                apex2.m_146870_();
            }
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnRageExplosion(Level level, Player player) {
        Vec3 playerPos = player.m_20182_().m_82520_(0.0, (double)player.m_20206_() * 0.5, 0.0);
        SphereParticleManager.spawnParticles(level, (Entity)player, 32, (ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get(), ParticleDirection.OUTWARD, 4.0);
        SphereParticleManager.spawnParticles(level, (Entity)player, 16, (ParticleOptions)ModParticle.SMALL_CURSED_FLAME.get(), ParticleDirection.OUTWARD, 4.0);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(SOUL_COLOR, (float)this.getCollectionRadius()), (double)playerPos.f_82479_, (double)playerPos.f_82480_, (double)playerPos.f_82481_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
    }

    private void spawnApexCollectionEffect(Level level, SoulApexEntity apex) {
        int i;
        AABB bounds = apex.m_20191_();
        Vec3 center = bounds.m_82399_();
        double width = bounds.m_82362_() * 0.5;
        double height = bounds.m_82376_();
        for (i = 0; i < 16; ++i) {
            double angle = (double)i / 16.0 * Math.PI * 2.0;
            double radius = width + 0.3;
            Vec3 particlePos = center.m_82520_(Math.cos(angle) * radius, level.f_46441_.m_188500_() * height, Math.sin(angle) * radius);
            Vec3 velocity = new Vec3((level.f_46441_.m_188500_() - 0.5) * 0.1, 0.1 + level.f_46441_.m_188500_() * 0.15, (level.f_46441_.m_188500_() - 0.5) * 0.1);
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleTypes.f_235898_, (double)particlePos.f_82479_, (double)particlePos.f_82480_, (double)particlePos.f_82481_, (int)1, (double)velocity.f_82479_, (double)velocity.f_82480_, (double)velocity.f_82481_, (double)0.0, (boolean)true);
        }
        for (i = 0; i < 8; ++i) {
            Vec3 randomPos = center.m_82520_((level.f_46441_.m_188500_() - 0.5) * width * 1.5, level.f_46441_.m_188500_() * height, (level.f_46441_.m_188500_() - 0.5) * width * 1.5);
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleTypes.f_123746_, (double)randomPos.f_82479_, (double)randomPos.f_82480_, (double)randomPos.f_82481_, (int)1, (double)((level.f_46441_.m_188500_() - 0.5) * 0.08), (double)(level.f_46441_.m_188500_() * 0.12), (double)((level.f_46441_.m_188500_() - 0.5) * 0.08), (double)0.0, (boolean)true);
        }
    }

    private void spawnAmbientRadiusEffect(Level level, Player player) {
        double radius;
        double angle;
        int i;
        Vec3 playerPos = player.m_20182_();
        for (i = 0; i < 32; ++i) {
            angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
            radius = 3.0 + level.f_46441_.m_188500_() * 4.0;
            double height = level.f_46441_.m_188500_() * 2.5;
            Vec3 particlePos = playerPos.m_82520_(Math.cos(angle) * radius, height, Math.sin(angle) * radius);
            Vec3 velocity = new Vec3((level.f_46441_.m_188500_() - 0.5) * 0.05, level.f_46441_.m_188500_() * 0.08, (level.f_46441_.m_188500_() - 0.5) * 0.05);
            if (level.f_46441_.m_188499_()) {
                MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleTypes.f_123762_, (double)particlePos.f_82479_, (double)particlePos.f_82480_, (double)particlePos.f_82481_, (int)1, (double)velocity.f_82479_, (double)velocity.f_82480_, (double)velocity.f_82481_, (double)0.0, (boolean)true);
                continue;
            }
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleTypes.f_235898_, (double)particlePos.f_82479_, (double)particlePos.f_82480_, (double)particlePos.f_82481_, (int)1, (double)velocity.f_82479_, (double)velocity.f_82480_, (double)velocity.f_82481_, (double)0.0, (boolean)true);
        }
        for (i = 0; i < 8; ++i) {
            angle = (double)i / 8.0 * Math.PI * 2.0;
            radius = 2.5;
            Vec3 ringPos = playerPos.m_82520_(Math.cos(angle) * radius, 0.2, Math.sin(angle) * radius);
            MagicManager.spawnParticles((Level)level, (ParticleOptions)((ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get()), (double)ringPos.f_82479_, (double)ringPos.f_82480_, (double)ringPos.f_82481_, (int)1, (double)0.0, (double)0.05, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    private double getCollectionRadius() {
        return 20.0;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.traveloptics.collection_radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getCollectionRadius(), (int)2)}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }
}

