/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.item.bossweapon.cursedwraithblade;

import com.gametechbc.traveloptics.data_manager.SoulApexManager;
import com.gametechbc.traveloptics.data_manager.SpiritPointsManager;
import com.gametechbc.traveloptics.data_manager.WeaponFormManager;
import com.gametechbc.traveloptics.entity.item.cursed_wraithblade.CursedWraithbladeItemRenderer;
import com.gametechbc.traveloptics.entity.misc.TOScreenShakeEntity;
import com.gametechbc.traveloptics.entity.misc.soul_apex.SoulApexEntity;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.item.bossweapon.cursedwraithblade.CursedWraithbladeLevelOneItem;
import com.gametechbc.traveloptics.util.TravelopticsParticleHelper;
import com.github.L_Ender.cataclysm.client.particle.LightningParticle;
import com.github.L_Ender.cataclysm.init.ModParticle;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.ISSDamageTypes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CursedWraithbladeLevelTwoItem
extends CursedWraithbladeLevelOneItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static ItemDisplayContext transformType;
    private DamageSource damageSource;
    protected static final int MODE_TOTAL_SHOT = 0;
    protected static final int MODE_QUICK_SHOT = 1;
    protected static final int QUICK_SHOT_SOUL_COST = 20;
    protected static final int QUICK_SHOT_CHARGE_TIME = 20;
    protected static final int CHARGE_TIME = 30;
    protected static final int COOLDOWN_MODE_SWITCH = 15;
    protected static final int COOLDOWN_QUICK_SHOT = 40;

    public CursedWraithbladeLevelTwoItem(SpellDataRegistryHolder[] imbuedSpells) {
        super(imbuedSpells);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int soulApexCount = SoulApexManager.getSoulApexCount(stack);
        if (player.m_6047_() && hand == InteractionHand.MAIN_HAND) {
            if (soulApexCount > 0) {
                player.m_5661_((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.manifestation_switch_error").m_130940_(ChatFormatting.RED), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            WeaponFormManager.cycleForm(stack, 2);
            int newMode = WeaponFormManager.getForm(stack);
            if (newMode == 1) {
                player.m_5661_((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.manifestation_switch.quick_shot").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.manifestation_switch.total_shot").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
            }
            if (!level.m_5776_()) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)TravelopticsSounds.MANIFESTATION_CHANGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            player.m_36335_().m_41524_((Item)this, 15);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        if (hand == InteractionHand.MAIN_HAND) {
            int currentMode = WeaponFormManager.getForm(stack);
            int spiritPoints = SpiritPointsManager.getSpiritPoints(stack);
            if (soulApexCount > 0) {
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            if (currentMode == 1 && spiritPoints < 20) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7cNot enough Soul Fragments! (Need 20)"), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @Override
    public int m_8105_(ItemStack stack) {
        int soulApexCount = SoulApexManager.getSoulApexCount(stack);
        int currentMode = WeaponFormManager.getForm(stack);
        if (soulApexCount > 0) {
            return 21;
        }
        if (currentMode == 1) {
            return 21;
        }
        return 31;
    }

    @Override
    public void m_5929_(Level level, LivingEntity caster, ItemStack stack, int count) {
        Player player;
        if (caster instanceof Player && (player = (Player)caster).m_7655_() == InteractionHand.MAIN_HAND) {
            int maxChargeTime;
            int soulApexCount = SoulApexManager.getSoulApexCount(stack);
            int currentMode = WeaponFormManager.getForm(stack);
            int chargeTime = this.m_8105_(stack) - count;
            ItemStack mainHand = player.m_21205_();
            boolean usingSoulApex = soulApexCount > 0;
            boolean useShortCharge = usingSoulApex || currentMode == 1;
            int n = maxChargeTime = useShortCharge ? 20 : 30;
            if (chargeTime == 2) {
                caster.m_5496_((SoundEvent)TravelopticsSounds.CURSED_BLAST_CHARGE.get(), 1.0f, 1.0f);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    String animName = useShortCharge ? "charge" : "charge_long";
                    this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)mainHand, (ServerLevel)serverLevel), "wraithblade", animName);
                }
            }
            if (count % 3 == 0 && chargeTime >= 2 && chargeTime < maxChargeTime && !level.f_46443_) {
                Vec3 lookVec = player.m_20252_(1.0f).m_82541_();
                Vec3 upVec = new Vec3(0.0, 1.0, 0.0);
                Vec3 rightVec = lookVec.m_82537_(upVec).m_82541_().m_82490_(0.22);
                Vec3 particleSpawnPos = player.m_146892_().m_82549_(lookVec.m_82490_(0.6)).m_82549_(rightVec);
                MagicManager.spawnParticles((Level)level, (ParticleOptions)new LightningParticle.OrbData(32, 181, 149), (double)particleSpawnPos.f_82479_, (double)particleSpawnPos.f_82480_, (double)particleSpawnPos.f_82481_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.2, (boolean)false);
            }
            if (chargeTime == maxChargeTime) {
                this.executeCursedBlast(level, player, mainHand);
            }
        }
    }

    @Override
    protected void executeCursedBlast(Level level, Player player, ItemStack stack) {
        Entity target;
        HitResult hitResult;
        boolean usingQuickShot;
        if (level.f_46443_) {
            return;
        }
        int currentMode = WeaponFormManager.getForm(stack);
        int soulApexCount = SoulApexManager.getSoulApexCount(stack);
        int spiritPoints = SpiritPointsManager.getSpiritPoints(stack);
        boolean usingSoulApex = soulApexCount > 0;
        boolean bl = usingQuickShot = currentMode == 1 && !usingSoulApex;
        float scaledDamage = usingSoulApex ? this.getSoulApexDamage(player) : (usingQuickShot ? this.getQuickShotDamage(player) : CursedWraithbladeLevelTwoItem.getBaseDamage() + (float)spiritPoints * this.getSoulConversionRate(player));
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "wraithblade", "shoot");
        }
        if ((hitResult = Utils.raycastForEntity((Level)level, (Entity)player, (float)CursedWraithbladeLevelTwoItem.getRange(), (boolean)true, (float)0.15f)).m_6662_() == HitResult.Type.ENTITY && (target = ((EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
            boolean damaged;
            LivingEntity livingTarget = (LivingEntity)target;
            if (this.damageSource == null) {
                this.damageSource = new DamageSource(DamageSources.getHolderFromResource((Entity)livingTarget, (ResourceKey)ISSDamageTypes.LIGHTNING_MAGIC), null, (Entity)player);
            }
            if ((damaged = livingTarget.m_6469_(this.damageSource, scaledDamage)) && usingSoulApex) {
                this.spawnSoulApexLightningExplosion(level, livingTarget, 16);
            }
            if (damaged && !usingSoulApex && !usingQuickShot && spiritPoints >= 50) {
                int soulApexToSpawn = spiritPoints / 50;
                for (int i = 0; i < soulApexToSpawn; ++i) {
                    Object soulApex = new SoulApexEntity(level, livingTarget.m_20185_(), livingTarget.m_20186_() + (double)livingTarget.m_20206_() * 0.5, livingTarget.m_20189_(), player, 1.0f);
                    level.m_7967_(soulApex);
                }
            }
            AABB area = new AABB(livingTarget.m_20183_()).m_82400_(3.0);
            List nearbyEntities = level.m_6443_(LivingEntity.class, area, e -> e != player && e != livingTarget);
            for (LivingEntity nearby : nearbyEntities) {
                if (this.damageSource == null) {
                    this.damageSource = new DamageSource(DamageSources.getHolderFromResource((Entity)nearby, (ResourceKey)ISSDamageTypes.LIGHTNING_MAGIC), null, (Entity)player);
                }
                float aoeDamage = usingSoulApex ? scaledDamage : scaledDamage * 0.5f;
                nearby.m_6469_(this.damageSource, aoeDamage);
                MagicManager.spawnParticles((Level)level, (ParticleOptions)((ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get()), (double)nearby.m_20185_(), (double)(nearby.m_20186_() + 1.0), (double)nearby.m_20189_(), (int)35, (double)0.0, (double)0.0, (double)0.0, (double)0.3, (boolean)false);
            }
            MagicManager.spawnParticles((Level)level, (ParticleOptions)((ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get()), (double)hitResult.m_82450_().f_82479_, (double)(hitResult.m_82450_().f_82480_ + 1.0), (double)hitResult.m_82450_().f_82481_, (int)50, (double)0.0, (double)0.0, (double)0.0, (double)0.2, (boolean)false);
        }
        float knockbackStrength = usingSoulApex ? 0.5f : (usingQuickShot ? 0.3f : (float)spiritPoints / 100.0f * 0.5f);
        Vec3 knockbackDirection = player.m_20154_().m_82548_().m_82490_((double)knockbackStrength);
        player.m_20334_(knockbackDirection.f_82479_, 0.15, knockbackDirection.f_82481_);
        player.f_19864_ = true;
        if (usingSoulApex) {
            this.doSoulApexPostEffects((LivingEntity)player, level);
            SoulApexManager.removeSoulApex(stack, player, 1);
        } else if (usingQuickShot) {
            this.doQuickShotPostEffects((LivingEntity)player, level);
            SpiritPointsManager.removeSpiritPoints(stack, player, 20);
        } else {
            this.doPostEffects((LivingEntity)player, spiritPoints, level);
            SpiritPointsManager.setSpiritPoints(stack, 0);
            player.m_5661_((Component)Component.m_237113_((String)"\u2620 Soul Fragments: 0").m_130940_(ChatFormatting.DARK_AQUA), true);
        }
        Vec3 lookVec = player.m_20252_(1.0f).m_82541_();
        Vec3 upVec = new Vec3(0.0, 1.0, 0.0);
        Vec3 rightVec = lookVec.m_82537_(upVec).m_82541_().m_82490_(0.22);
        Vec3 nozzlePos = player.m_146892_().m_82549_(lookVec.m_82490_(0.6)).m_82549_(rightVec);
        float distance = CursedWraithbladeLevelTwoItem.getRange();
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            distance = (float)hitResult.m_82448_((Entity)player);
        }
        int i = 0;
        while ((float)i < distance) {
            Vec3 particlePos = lookVec.m_82490_((double)i).m_82549_(nozzlePos);
            MagicManager.spawnParticles((Level)level, (ParticleOptions)TravelopticsParticleHelper.CURSED_BLAST, (double)particlePos.f_82479_, (double)particlePos.f_82480_, (double)particlePos.f_82481_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
            ++i;
        }
        if (usingSoulApex) {
            player.m_36335_().m_41524_((Item)this, 60);
        } else if (usingQuickShot) {
            player.m_36335_().m_41524_((Item)this, 40);
        } else {
            player.m_36335_().m_41524_((Item)this, 80);
        }
    }

    protected float getQuickShotDamage(Player player) {
        return 15.0f;
    }

    private void doQuickShotPostEffects(LivingEntity entity, Level level) {
        level.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.BLAST_STAGE_TWO.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        TOScreenShakeEntity.createScreenShake(level, entity.m_20182_(), 20.0f, 0.015f, 10, 0, 10, true);
    }

    private void doSoulApexPostEffects(LivingEntity entity, Level level) {
        level.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.BLAST_STAGE_THREE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        TOScreenShakeEntity.createScreenShake(level, entity.m_20182_(), 20.0f, 0.02f, 10, 0, 10, true);
    }

    private void doPostEffects(LivingEntity entity, int spiritPoints, Level level) {
        if (spiritPoints >= 200) {
            level.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.BLAST_STAGE_THREE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            TOScreenShakeEntity.createScreenShake(level, entity.m_20182_(), 30.0f, 0.035f, 10, 0, 10, true);
        } else if (spiritPoints >= 100) {
            level.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.BLAST_STAGE_TWO.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            TOScreenShakeEntity.createScreenShake(level, entity.m_20182_(), 20.0f, 0.02f, 10, 0, 10, true);
        } else if (spiritPoints >= 0) {
            level.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.BLAST_STAGE_ONE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            TOScreenShakeEntity.createScreenShake(level, entity.m_20182_(), 15.0f, 0.015f, 10, 0, 10, true);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        int soulApexCount = SoulApexManager.getSoulApexCount(stack);
        boolean hasSoulApex = soulApexCount > 0;
        int currentMode = WeaponFormManager.getForm(stack);
        String modeKey = hasSoulApex ? "item.traveloptics.cursed_wraithblade.manifestation.apex_shot" : (currentMode == 1 ? "item.traveloptics.cursed_wraithblade.manifestation.quick_shot" : "item.traveloptics.cursed_wraithblade.manifestation.total_shot");
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.soul_collector").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.soul_collector1"));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.cursed_blast").m_7220_((Component)Component.m_237113_((String)" [").m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)Component.m_237115_((String)modeKey).m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.LIGHT_PURPLE)).m_130940_(ChatFormatting.GREEN));
        if (hasSoulApex) {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.cursed_blast_apex"));
        } else if (currentMode == 1) {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.cursed_blast2"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.cursed_blast1"));
        }
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.weapons.evolution_benefits.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.evo_one.active.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.evo_two.active.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.evo_three.inactive.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.weapons.manifestation_change.tooltip"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.weapons.evolution.stars_two.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.shift_hold.advanced_tooltips"));
        }
        tooltip.add((Component)Component.m_237113_((String)""));
        int spiritPoints = SpiritPointsManager.getSpiritPoints(stack);
        int maxSoulApex = 5;
        int maxSpiritPoints = 200;
        tooltip.add((Component)Component.m_237110_((String)"item.traveloptics.cursed_wraithblade.tooltip.soul_resources", (Object[])new Object[]{soulApexCount, maxSoulApex, spiritPoints, maxSpiritPoints}).m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237113_((String)""));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void getTransformType(ItemDisplayContext type) {
        transformType = type;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BlockEntityWithoutLevelRenderer getRenderer() {
        return new CursedWraithbladeItemRenderer();
    }
}

