/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.item.bossweapon.cursedwraithblade;

import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.data_manager.SoulApexManager;
import com.gametechbc.traveloptics.data_manager.SpiritPointsManager;
import com.gametechbc.traveloptics.data_manager.WeaponFormManager;
import com.gametechbc.traveloptics.entity.item.cursed_wraithblade.CursedWraithbladeItemRenderer;
import com.gametechbc.traveloptics.item.bossweapon.cursedwraithblade.CursedWraithbladeLevelTwoItem;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CursedWraithbladeLevelThreeItem
extends CursedWraithbladeLevelTwoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public CursedWraithbladeLevelThreeItem(SpellDataRegistryHolder[] imbuedSpells) {
        super(imbuedSpells);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    protected float getSoulConversionRate(Player player) {
        float spellPowerScaling = TOGeneralUtils.getSpellPowerScaling((LivingEntity)player, (Attribute)AttributeRegistry.SPELL_POWER.get(), (Attribute)AttributeRegistry.ICE_SPELL_POWER.get());
        return 0.75f + spellPowerScaling * 0.25f;
    }

    @Override
    protected float getQuickShotDamage(Player player) {
        float spellPowerScaling = TOGeneralUtils.getSpellPowerScaling((LivingEntity)player, (Attribute)AttributeRegistry.SPELL_POWER.get(), (Attribute)AttributeRegistry.ICE_SPELL_POWER.get());
        return 15.0f + spellPowerScaling * 5.0f;
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        int soulApexCount = SoulApexManager.getSoulApexCount(stack);
        boolean hasSoulApex = soulApexCount > 0;
        int currentMode = WeaponFormManager.getForm(stack);
        String modeKey = hasSoulApex ? "item.traveloptics.cursed_wraithblade.manifestation.apex_shot" : (currentMode == 1 ? "item.traveloptics.cursed_wraithblade.manifestation.quick_shot" : "item.traveloptics.cursed_wraithblade.manifestation.total_shot");
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.soul_collector").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.soul_collector1"));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.cursed_blast").m_7220_((Component)Component.m_237113_((String)" [").m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)Component.m_237115_((String)modeKey).m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.LIGHT_PURPLE)).m_130940_(ChatFormatting.GREEN));
        if (hasSoulApex) {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.cursed_blast_apex"));
        } else if (currentMode == 1) {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.cursed_blast2"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.tooltip.cursed_blast1"));
        }
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.weapons.evolution_benefits.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.evo_one.active.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.evo_two.active.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.cursed_wraithblade.evo_three.active.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.weapons.manifestation_change.tooltip"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.weapons.evolution.stars_three.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.shift_hold.advanced_tooltips"));
        }
        tooltip.add((Component)Component.m_237113_((String)""));
        int spiritPoints = SpiritPointsManager.getSpiritPoints(stack);
        int maxSoulApex = 5;
        int maxSpiritPoints = 200;
        tooltip.add((Component)Component.m_237110_((String)"item.traveloptics.cursed_wraithblade.tooltip.soul_resources", (Object[])new Object[]{soulApexCount, maxSoulApex, spiritPoints, maxSpiritPoints}).m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237113_((String)""));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BlockEntityWithoutLevelRenderer getRenderer() {
        return new CursedWraithbladeItemRenderer();
    }
}

