/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.item.armor;

import com.gametechbc.traveloptics.api.item.armor.IKeybindArmor;
import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.data_manager.CooldownsManager;
import com.gametechbc.traveloptics.data_manager.SwitchManager;
import com.gametechbc.traveloptics.entity.armor.tectonic_crest_armor.TectonicCrestArmorModel;
import com.gametechbc.traveloptics.entity.armor.tectonic_crest_armor.TectonicCrestArmorRenderer;
import com.gametechbc.traveloptics.entity.projectiles.GalenaTremorAoe;
import com.gametechbc.traveloptics.init.TravelopticsKeybinds;
import com.gametechbc.traveloptics.init.TravelopticsMessages;
import com.gametechbc.traveloptics.item.TravelopticsArmorMaterials;
import com.gametechbc.traveloptics.item.UnbreakableImbueableArmor;
import com.gametechbc.traveloptics.network.ArmorKeyPacket;
import com.gametechbc.traveloptics.util.TravelopticsDamageTypes;
import com.gametechbc.traveloptics.util.TravelopticsKeybindManager;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class TectonicCrestArmorItem
extends UnbreakableImbueableArmor
implements IKeybindArmor {
    private static final double KNOCKBACK_RADIUS = 7.0;
    private static final float KNOCKBACK_FORCE = 2.0f;
    private static final float BASE_DAMAGE = 6.0f;
    private static final int FIRE_DURATION_SECONDS = 10;
    private static final String ABILITY_TECTONIC_WARD = "tectonic_ward";
    public static final String COOLDOWN_TECTONIC_WARD = "tectonic_ward";
    private static final String COOLDOWN_TECTONIC_TOGGLE = "tectonic_toggle";
    private static final int COOLDOWN_TECTONIC_TOGGLE_TICKS = 20;
    public static final int COOLDOWN_TICKS = 400;
    private static final int FIRE_RESISTANCE_DURATION = 200;

    public TectonicCrestArmorItem(ArmorItem.Type slot, Item.Properties settings) {
        super(TravelopticsArmorMaterials.TECTONIC_CREST, slot, settings);
    }

    @Override
    protected Set<ArmorItem.Type> getImbuableArmorTypes() {
        return Set.of(ArmorItem.Type.CHESTPLATE);
    }

    @Override
    protected Map<ArmorItem.Type, Integer> getMaxSpellSlots() {
        return Map.of(ArmorItem.Type.CHESTPLATE, 1);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        if (stack != chestplate || chestplate.m_41720_() != this) {
            return;
        }
        if (!TectonicCrestArmorItem.isWearingFullSet(player)) {
            return;
        }
        if (!level.f_46443_) {
            CooldownsManager.tickCooldown(chestplate);
            this.grantFireResistance(player);
        }
        if (level.f_46443_ && TravelopticsKeybindManager.getClientSidePlayer() == player && TravelopticsKeybindManager.isKeyDown(4)) {
            TravelopticsMessages.sendToServer(new ArmorKeyPacket(EquipmentSlot.CHEST.ordinal(), player.m_19879_(), 4));
            this.onKeyPacket(player, stack, 4);
        }
    }

    public static void onPlayerTakeDamage(Player player, ItemStack chestplate, float damageAmount) {
        if (!TectonicCrestArmorItem.isWearingFullSet(player)) {
            return;
        }
        if (!SwitchManager.isEnabled(chestplate, "tectonic_ward")) {
            return;
        }
        if (CooldownsManager.getCooldown(chestplate, "tectonic_ward") > 0) {
            return;
        }
        TectonicCrestArmorItem.triggerTectonicShockwave(player, damageAmount);
        CooldownsManager.setCooldown(chestplate, "tectonic_ward", 400, 400);
    }

    private static void triggerTectonicShockwave(Player player, float damageAmount) {
        Level level = player.m_9236_();
        if (level.f_46443_) {
            return;
        }
        float spellPowerMultiplier = TOGeneralUtils.getSpellPowerScaling((LivingEntity)player, (Attribute)AttributeRegistry.FIRE_SPELL_POWER.get(), (Attribute)AttributeRegistry.SPELL_POWER.get());
        float finalDamage = (6.0f + damageAmount) * spellPowerMultiplier * 1.5f;
        AABB boundingBox = new AABB(player.m_20185_() - 7.0, player.m_20186_() - 7.0, player.m_20189_() - 7.0, player.m_20185_() + 7.0, player.m_20186_() + 7.0, player.m_20189_() + 7.0);
        List nearbyEntities = level.m_6443_(LivingEntity.class, boundingBox, entity -> {
            TamableAnimal tamable;
            if (entity == player) {
                return false;
            }
            if (player.m_7307_((Entity)entity)) {
                return false;
            }
            if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_()) {
                return tamable.m_269323_() != player;
            }
            return true;
        });
        for (LivingEntity entity2 : nearbyEntities) {
            DamageSource shockwaveDamageSource = new DamageSource(DamageSources.getHolderFromResource((Entity)entity2, TravelopticsDamageTypes.TECTONIC_CREST), (Entity)player, null);
            Vec3 knockbackVector = entity2.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_(2.0);
            entity2.m_20256_(knockbackVector);
            entity2.m_6469_(shockwaveDamageSource, finalDamage);
            entity2.m_20254_(10);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_STOMP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.FIRE.get()).getTargetingColor(), 7.0f), (double)player.m_20185_(), (double)(player.m_20186_() + (double)0.165f), (double)player.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        Vec3 playerPos = player.m_20182_();
        TectonicCrestArmorItem.spawnGalenaTremorAoe(level, player, playerPos);
        TectonicCrestArmorItem.spawnFireParticles(level, playerPos);
        TectonicCrestArmorItem.spawnLavaPopParticles(level, playerPos);
    }

    private static void spawnGalenaTremorAoe(Level level, Player player, Vec3 pos) {
        GalenaTremorAoe tremorAoe = new GalenaTremorAoe(level, 7.0f);
        tremorAoe.m_5602_((Entity)player);
        tremorAoe.m_20219_(pos);
        level.m_7967_((Entity)tremorAoe);
    }

    private static void spawnFireParticles(Level level, Vec3 center) {
        for (int i = 0; i < 35; ++i) {
            double angle = level.f_46441_.m_188500_() * 2.0 * Math.PI;
            double distance = level.f_46441_.m_188500_() * 7.0;
            double x = center.f_82479_ + Math.cos(angle) * distance;
            double z = center.f_82481_ + Math.sin(angle) * distance;
            double y = center.f_82480_ + 0.5;
            double vy = 0.15 + level.f_46441_.m_188500_() * 0.2;
            double vx = (level.f_46441_.m_188500_() - 0.5) * 0.08;
            double vz = (level.f_46441_.m_188500_() - 0.5) * 0.08;
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.EMBERS, (double)x, (double)y, (double)z, (int)1, (double)vx, (double)vy, (double)vz, (double)0.15, (boolean)false);
        }
    }

    private static void spawnLavaPopParticles(Level level, Vec3 center) {
        for (int i = 0; i < 25; ++i) {
            double angle = level.f_46441_.m_188500_() * 2.0 * Math.PI;
            double distance = level.f_46441_.m_188500_() * 7.0 * 0.8;
            double x = center.f_82479_ + Math.cos(angle) * distance;
            double z = center.f_82481_ + Math.sin(angle) * distance;
            double y = center.f_82480_ - 0.7;
            double vy = 0.08 + level.f_46441_.m_188500_() * 0.12;
            double vx = (level.f_46441_.m_188500_() - 0.5) * 0.12;
            double vz = (level.f_46441_.m_188500_() - 0.5) * 0.12;
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleTypes.f_123756_, (double)x, (double)y, (double)z, (int)1, (double)vx, (double)vy, (double)vz, (double)0.12, (boolean)false);
        }
    }

    @Override
    public void onKeyPacket(Player player, ItemStack itemStack, int key) {
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        if (chestplate.m_41619_() || chestplate.m_41720_() != this) {
            return;
        }
        if (key == 4) {
            int toggleCooldown = CooldownsManager.getCooldown(chestplate, COOLDOWN_TECTONIC_TOGGLE);
            if (toggleCooldown > 0) {
                return;
            }
            boolean wasEnabled = SwitchManager.isEnabled(chestplate, "tectonic_ward");
            SwitchManager.toggleSwitch(chestplate, "tectonic_ward");
            boolean isNowEnabled = !wasEnabled;
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_JUMP.get(), SoundSource.PLAYERS, 1.0f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
            if (isNowEnabled) {
                player.m_5661_((Component)Component.m_237115_((String)"item.traveloptics.tectonic_crest.message.tectonic_ward_enabled").m_130940_(ChatFormatting.GREEN), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.traveloptics.tectonic_crest.message.tectonic_ward_disabled").m_130940_(ChatFormatting.RED), true);
            }
            CooldownsManager.setCooldown(chestplate, COOLDOWN_TECTONIC_TOGGLE, 20, 20);
        }
    }

    private void grantFireResistance(Player player) {
        if (!player.m_21023_(MobEffects.f_19607_)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 0, false, false));
        }
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237110_((String)"item.traveloptics.tectonic_crest_armor.tooltip.tectonic_ward_keybind", (Object[])new Object[]{TravelopticsKeybinds.KEY_B.m_90863_()}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.tectonic_crest_armor.tooltip").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.tectonic_crest_armor.tooltip1"));
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.tectonic_crest_armor.tooltip2"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.shift_hold.advanced_tooltips"));
        }
        if (this.f_265916_ == ArmorItem.Type.CHESTPLATE) {
            tooltip.add((Component)Component.m_237113_((String)""));
            boolean isEnabled = SwitchManager.isEnabled(stack, "tectonic_ward");
            String statusKey = isEnabled ? "enabled" : "disabled";
            tooltip.add((Component)Component.m_237113_((String)"[").m_7220_(TravelopticsKeybinds.KEY_B.m_90863_()).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237115_((String)("item.traveloptics.tectonic_crest.ability.tectonic_ward.status." + statusKey))));
        }
        tooltip.add((Component)Component.m_237113_((String)""));
    }

    public static boolean isWearingFullSet(Player player) {
        return player.m_6844_(ArmorItem.Type.HELMET.m_266308_()).m_41720_() instanceof TectonicCrestArmorItem && player.m_6844_(ArmorItem.Type.CHESTPLATE.m_266308_()).m_41720_() instanceof TectonicCrestArmorItem && player.m_6844_(ArmorItem.Type.LEGGINGS.m_266308_()).m_41720_() instanceof TectonicCrestArmorItem && player.m_6844_(ArmorItem.Type.BOOTS.m_266308_()).m_41720_() instanceof TectonicCrestArmorItem;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GeoArmorRenderer<?> supplyRenderer() {
        return new TectonicCrestArmorRenderer(new TectonicCrestArmorModel());
    }
}

