/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.events;

import com.gametechbc.traveloptics.config.ClientConfig;
import com.gametechbc.traveloptics.entity.misc.TOPowerInversionEntity;
import com.gametechbc.traveloptics.entity.misc.TOScreenFlashEntity;
import com.gametechbc.traveloptics.overlay.ScreenEffectOverlayHelper;
import com.gametechbc.traveloptics.overlay.SpectralBlinkActivationOverlay;
import com.gametechbc.traveloptics.overlay.SpectralBlinkOverlay;
import com.gametechbc.traveloptics.overlay.armor_overlay.AbyssalHideOverlay;
import com.gametechbc.traveloptics.overlay.armor_overlay.DarknessOverlay;
import com.gametechbc.traveloptics.overlay.armor_overlay.PhantomRageOverlay;
import com.gametechbc.traveloptics.overlay.armor_overlay.PlasmaFuelOverlay;
import com.gametechbc.traveloptics.overlay.armor_overlay.PrimordialCrestOverlay;
import com.gametechbc.traveloptics.overlay.armor_overlay.RiptideSovereignOverlay;
import com.gametechbc.traveloptics.overlay.armor_overlay.TectonicCrestOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="traveloptics", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ForgeClientOverlayEvent {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !Minecraft.m_91087_().m_91104_()) {
            GuiGraphics guiGraphics = event.getGuiGraphics();
            if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && ((Boolean)ClientConfig.activateScreenFlash.get()).booleanValue()) {
                float delta = Minecraft.m_91087_().m_91296_();
                ForgeClientOverlayEvent.processScreenFlashEffects((Player)player, delta, guiGraphics);
                ForgeClientOverlayEvent.processPowerInversionEffects((Player)player, delta, guiGraphics);
            }
            int screenWidth = event.getWindow().m_85445_();
            int screenHeight = event.getWindow().m_85446_();
            DarknessOverlay.render(guiGraphics, (Player)player, screenWidth, screenHeight);
            TectonicCrestOverlay.render(guiGraphics, (Player)player, screenWidth, screenHeight);
            PrimordialCrestOverlay.render(guiGraphics, (Player)player, screenWidth, screenHeight);
            PlasmaFuelOverlay.render(guiGraphics, (Player)player, screenWidth, screenHeight);
            AbyssalHideOverlay.render(guiGraphics, (Player)player, screenWidth, screenHeight);
            PhantomRageOverlay.render(guiGraphics, (Player)player, screenWidth, screenHeight);
            RiptideSovereignOverlay.render(guiGraphics, (Player)player, screenWidth, screenHeight);
            SpectralBlinkOverlay.renderOverlay(guiGraphics, (Player)player, screenWidth, screenHeight);
            SpectralBlinkActivationOverlay.renderOverlay(guiGraphics, (Player)player, screenWidth, screenHeight);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderArmorXpBars(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() != VanillaGuiOverlay.EXPERIENCE_BAR.type()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (DarknessOverlay.shouldCancelXpBar((Player)player) || TectonicCrestOverlay.shouldCancelXpBar((Player)player) || PrimordialCrestOverlay.shouldCancelXpBar((Player)player) || PlasmaFuelOverlay.shouldCancelXpBar((Player)player) || AbyssalHideOverlay.shouldCancelXpBar((Player)player) || RiptideSovereignOverlay.shouldCancelXpBar((Player)player) || PhantomRageOverlay.shouldCancelXpBar((Player)player)) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processScreenFlashEffects(Player player, float delta, GuiGraphics guiGraphics) {
        float totalFlashAlpha = 0.0f;
        int flashColor = 0xFFFFFF;
        for (TOScreenFlashEntity flash : player.m_9236_().m_45976_(TOScreenFlashEntity.class, player.m_20191_().m_82377_(50.0, 50.0, 50.0))) {
            float alpha;
            if (!(flash.m_20270_((Entity)player) <= flash.getRadius()) || !((alpha = flash.getFlashAlpha(player, delta)) > totalFlashAlpha)) continue;
            totalFlashAlpha = alpha;
            flashColor = flash.getFlashColor();
        }
        if (totalFlashAlpha > 1.0f) {
            totalFlashAlpha = 1.0f;
        }
        if (totalFlashAlpha > 0.0f) {
            ScreenEffectOverlayHelper.renderFlashOverlay(guiGraphics, totalFlashAlpha, flashColor);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processPowerInversionEffects(Player player, float delta, GuiGraphics guiGraphics) {
        TOPowerInversionEntity.PowerEffectData combinedEffect = new TOPowerInversionEntity.PowerEffectData(0.0f, 0.0f, TOPowerInversionEntity.EffectPhase.NONE);
        boolean shouldInvert = false;
        int flashColor = 0xF8F8F8;
        for (TOPowerInversionEntity powerEffect : player.m_9236_().m_45976_(TOPowerInversionEntity.class, player.m_20191_().m_82377_(50.0, 50.0, 50.0))) {
            if (!(powerEffect.m_20270_((Entity)player) <= powerEffect.getRadius())) continue;
            TOPowerInversionEntity.PowerEffectData effectData = powerEffect.getEffectData(player, delta);
            if (effectData.phase == TOPowerInversionEntity.EffectPhase.NONE || !(effectData.flashIntensity > combinedEffect.flashIntensity) && !(effectData.effectIntensity > combinedEffect.effectIntensity)) continue;
            combinedEffect = effectData;
            shouldInvert = powerEffect.shouldInvertColors();
            flashColor = powerEffect.getFlashColor();
        }
        if (combinedEffect.phase != TOPowerInversionEntity.EffectPhase.NONE) {
            ScreenEffectOverlayHelper.renderPowerInversionOverlay(guiGraphics, combinedEffect, shouldInvert, flashColor);
        }
    }
}

