/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.misc.soul_apex;

import com.gametechbc.traveloptics.init.TravelopticsEntities;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class SoulApexEntity
extends Entity {
    private static final int FRAME_DURATION = 4;
    private static final int MAX_FRAMES = 11;
    private static final int DEFAULT_LIFETIME = 1200;
    private static final float DEFAULT_VELOCITY_MULTIPLIER = 1.0f;
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID = SynchedEntityData.m_135353_(SoulApexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> DATA_DURATION = SynchedEntityData.m_135353_(SoulApexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_VELOCITY_MULTIPLIER = SynchedEntityData.m_135353_(SoulApexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_ANIMATION_OFFSET = SynchedEntityData.m_135353_(SoulApexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Player cachedOwner = null;

    public SoulApexEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
        this.f_19794_ = false;
    }

    public SoulApexEntity(Level level, double x, double y, double z) {
        this((EntityType)TravelopticsEntities.SOUL_APEX.get(), level);
        this.m_6034_(x, y, z);
        this.setDuration(1200);
        this.setVelocityMultiplier(1.0f);
        this.setAnimationOffset(this.f_19796_.m_188503_(1000));
        this.applyRandomSpreadVelocity();
    }

    public SoulApexEntity(Level level, double x, double y, double z, Player owner) {
        this(level, x, y, z);
        this.setOwner(owner);
    }

    public SoulApexEntity(Level level, double x, double y, double z, Player owner, int duration) {
        this(level, x, y, z, owner);
        this.setDuration(duration);
    }

    public SoulApexEntity(Level level, double x, double y, double z, Player owner, float velocityMultiplier) {
        this(level, x, y, z, owner);
        this.setVelocityMultiplier(velocityMultiplier);
        this.applyRandomSpreadVelocity();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_DURATION, (Object)1200);
        this.f_19804_.m_135372_(DATA_VELOCITY_MULTIPLIER, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_ANIMATION_OFFSET, (Object)0);
    }

    private void applyRandomSpreadVelocity() {
        float multiplier = this.getVelocityMultiplier();
        double xVel = (this.f_19796_.m_188500_() * 0.4 - 0.2) * (double)multiplier;
        double yVel = (this.f_19796_.m_188500_() * 0.3 + 0.1) * (double)multiplier;
        double zVel = (this.f_19796_.m_188500_() * 0.4 - 0.2) * (double)multiplier;
        this.m_20334_(xVel, yVel, zVel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ >= this.getDuration()) {
            this.m_146870_();
            return;
        }
        Vec3 motion = this.m_20184_();
        if (!this.m_20068_()) {
            this.m_20256_(motion.m_82520_(0.0, -0.03, 0.0));
        }
        if (!this.m_9236_().m_45772_(this.m_20191_())) {
            this.m_20314_(this.m_20185_(), (this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0, this.m_20189_());
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        float friction = 0.98f;
        if (this.m_20096_()) {
            BlockPos pos = this.m_20099_();
            friction = this.m_9236_().m_8055_(pos).getFriction((LevelReader)this.m_9236_(), pos, (Entity)this) * 0.98f;
        }
        this.m_20256_(this.m_20184_().m_82542_((double)friction, 0.98, (double)friction));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, -0.9, 1.0));
        }
    }

    public int getCurrentFrame() {
        int totalTicks = this.f_19797_ + this.getAnimationOffset();
        return totalTicks / 4 % 11;
    }

    public int getAnimationOffset() {
        return (Integer)this.f_19804_.m_135370_(DATA_ANIMATION_OFFSET);
    }

    public void setAnimationOffset(int offset) {
        this.f_19804_.m_135381_(DATA_ANIMATION_OFFSET, (Object)offset);
    }

    @Nullable
    public Player getOwner() {
        Player player;
        ServerLevel serverLevel;
        Entity foundEntity;
        Level level;
        if (this.cachedOwner != null && this.cachedOwner.m_6084_()) {
            return this.cachedOwner;
        }
        Optional ownerUUID = (Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID);
        if (ownerUUID.isPresent() && (level = this.m_9236_()) instanceof ServerLevel && (foundEntity = (serverLevel = (ServerLevel)level).m_8791_((UUID)ownerUUID.get())) instanceof Player && (player = (Player)foundEntity).m_6084_()) {
            this.cachedOwner = player;
            return this.cachedOwner;
        }
        return null;
    }

    public void setOwner(@Nullable Player owner) {
        if (owner != null) {
            this.f_19804_.m_135381_(DATA_OWNER_UUID, Optional.of(owner.m_20148_()));
            this.cachedOwner = owner;
        } else {
            this.f_19804_.m_135381_(DATA_OWNER_UUID, Optional.empty());
            this.cachedOwner = null;
        }
    }

    public boolean isOwner(Player player) {
        Player owner = this.getOwner();
        return owner != null && owner.equals((Object)player);
    }

    public int getDuration() {
        return (Integer)this.f_19804_.m_135370_(DATA_DURATION);
    }

    public void setDuration(int duration) {
        this.f_19804_.m_135381_(DATA_DURATION, (Object)Math.max(1, duration));
    }

    public float getVelocityMultiplier() {
        return ((Float)this.f_19804_.m_135370_(DATA_VELOCITY_MULTIPLIER)).floatValue();
    }

    public void setVelocityMultiplier(float multiplier) {
        this.f_19804_.m_135381_(DATA_VELOCITY_MULTIPLIER, (Object)Float.valueOf(Math.max(0.1f, multiplier)));
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("OwnerUUID")) {
            this.f_19804_.m_135381_(DATA_OWNER_UUID, Optional.of(compound.m_128342_("OwnerUUID")));
        }
        if (compound.m_128441_("Duration")) {
            this.setDuration(compound.m_128451_("Duration"));
        }
        if (compound.m_128441_("VelocityMultiplier")) {
            this.setVelocityMultiplier(compound.m_128457_("VelocityMultiplier"));
        }
        if (compound.m_128441_("AnimationOffset")) {
            this.setAnimationOffset(compound.m_128451_("AnimationOffset"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        Optional ownerUUID = (Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID);
        if (ownerUUID.isPresent()) {
            compound.m_128362_("OwnerUUID", (UUID)ownerUUID.get());
        }
        compound.m_128405_("Duration", this.getDuration());
        compound.m_128350_("VelocityMultiplier", this.getVelocityMultiplier());
        compound.m_128405_("AnimationOffset", this.getAnimationOffset());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

