/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.misc.galena_mark;

import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.init.TravelopticsEntities;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Vector3f;

public class GalenaMarkEntity
extends Entity {
    private static final int MAX_DURATION = 30;
    private static final double SCAN_RADIUS = 6.0;
    private static final double PUSH_FORCE = 1.5;
    private static final double PULL_FORCE = 1.5;
    private static final EntityDataAccessor<Boolean> IS_AZURE = SynchedEntityData.m_135353_(GalenaMarkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(GalenaMarkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Y_OFFSET = SynchedEntityData.m_135353_(GalenaMarkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> TARGET_UUID = SynchedEntityData.m_135353_(GalenaMarkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.m_135353_(GalenaMarkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private Entity cachedTarget;
    private Entity cachedCaster;
    private float damagePerTick;

    public GalenaMarkEntity(EntityType<? extends GalenaMarkEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
        this.f_19794_ = true;
    }

    public GalenaMarkEntity(Level level, Entity target, Entity caster, boolean isAzure, float totalDamage, float yOffset) {
        this((EntityType<? extends GalenaMarkEntity>)((EntityType)TravelopticsEntities.GALENA_MARK.get()), level);
        this.setTarget(target);
        this.setCaster(caster);
        this.setAzure(isAzure);
        this.setDamage(totalDamage);
        this.setYOffset(yOffset);
        this.damagePerTick = totalDamage / 30.0f;
        this.updatePosition();
        this.f_19811_ = true;
        this.f_19794_ = true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(IS_AZURE, (Object)false);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(Y_OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_UUID, Optional.empty());
        this.f_19804_.m_135372_(CASTER_UUID, Optional.empty());
    }

    public void m_8119_() {
        super.m_8119_();
        Entity target = this.getTarget();
        if (target == null || !target.m_6084_()) {
            this.m_146870_();
            return;
        }
        this.updatePosition();
        if (!this.m_9236_().f_46443_) {
            if (this.f_19797_ >= 30) {
                this.triggerMagneticBlast();
                this.m_5496_((SoundEvent)SoundRegistry.ECHOING_STRIKE.get(), 1.0f, 0.75f);
                this.m_146870_();
                return;
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                Entity caster = this.getCaster();
                DamageSource damageSource = caster != null ? this.m_9236_().m_269111_().m_269333_((LivingEntity)caster) : this.m_9236_().m_269111_().m_269425_();
                livingTarget.m_6469_(damageSource, this.damagePerTick);
                livingTarget.f_19802_ = 0;
                DamageSources.ignoreNextKnockback((LivingEntity)livingTarget);
            }
        }
    }

    private void triggerMagneticBlast() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity target = this.getTarget();
        if (target == null) {
            return;
        }
        boolean thisIsAzure = this.isAzure();
        Vec3 thisPos = target.m_20182_();
        AABB targetBB = target.m_20191_();
        Vec3 centerPos = targetBB.m_82399_();
        Vector3f particleColor = thisIsAzure ? TOGeneralUtils.hexToVector3f(24815) : TOGeneralUtils.hexToVector3f(16711722);
        MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(particleColor, 6.0f), (double)centerPos.f_82479_, (double)centerPos.f_82480_, (double)centerPos.f_82481_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        AABB searchArea = new AABB(thisPos.f_82479_ - 6.0, thisPos.f_82480_ - 6.0, thisPos.f_82481_ - 6.0, thisPos.f_82479_ + 6.0, thisPos.f_82480_ + 6.0, thisPos.f_82481_ + 6.0);
        List nearbyMarks = this.m_9236_().m_45976_(GalenaMarkEntity.class, searchArea);
        for (GalenaMarkEntity otherMark : nearbyMarks) {
            Entity otherTarget;
            if (otherMark.equals((Object)this) || (otherTarget = otherMark.getTarget()) == null || !otherTarget.m_6084_()) continue;
            boolean otherIsAzure = otherMark.isAzure();
            Vec3 otherPos = otherTarget.m_20182_();
            Vec3 direction = otherPos.m_82546_(thisPos).m_82541_();
            if (thisIsAzure == otherIsAzure) {
                Vec3 pullVelocity = direction.m_82490_(1.5);
                otherTarget.m_20256_(otherTarget.m_20184_().m_82549_(pullVelocity));
            } else {
                Vec3 pushVelocity = direction.m_82490_(-1.5);
                otherTarget.m_20256_(otherTarget.m_20184_().m_82549_(pushVelocity));
            }
            otherTarget.f_19864_ = true;
        }
    }

    private void updatePosition() {
        Entity target = this.getTarget();
        if (target != null) {
            double x = target.m_20185_();
            double y = target.m_20186_() + (double)target.m_20206_() + (double)this.getYOffset();
            double z = target.m_20189_();
            this.m_6034_(x, y, z);
        }
    }

    @Nullable
    private Entity getTarget() {
        if (this.cachedTarget != null && !this.cachedTarget.m_213877_()) {
            return this.cachedTarget;
        }
        Optional targetUUID = (Optional)this.f_19804_.m_135370_(TARGET_UUID);
        if (targetUUID.isPresent()) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Entity entity = serverLevel.m_8791_((UUID)targetUUID.get());
                if (entity != null) {
                    this.cachedTarget = entity;
                    return entity;
                }
            } else {
                for (Entity entity : this.m_9236_().m_45976_(Entity.class, this.m_20191_().m_82400_(32.0))) {
                    if (!entity.m_20148_().equals(targetUUID.get())) continue;
                    this.cachedTarget = entity;
                    return entity;
                }
            }
        }
        this.cachedTarget = null;
        return null;
    }

    public void setTarget(Entity target) {
        if (target != null) {
            this.f_19804_.m_135381_(TARGET_UUID, Optional.of(target.m_20148_()));
            this.cachedTarget = target;
        } else {
            this.f_19804_.m_135381_(TARGET_UUID, Optional.empty());
            this.cachedTarget = null;
        }
    }

    @Nullable
    public Entity getCaster() {
        ServerLevel serverLevel;
        Entity foundEntity;
        Level level;
        if (this.cachedCaster != null && this.cachedCaster.m_6084_()) {
            return this.cachedCaster;
        }
        Optional casterUUID = (Optional)this.f_19804_.m_135370_(CASTER_UUID);
        if (casterUUID.isPresent() && (level = this.m_9236_()) instanceof ServerLevel && (foundEntity = (serverLevel = (ServerLevel)level).m_8791_((UUID)casterUUID.get())) != null && foundEntity.m_6084_()) {
            this.cachedCaster = foundEntity;
            return this.cachedCaster;
        }
        return null;
    }

    public void setCaster(Entity caster) {
        if (caster != null) {
            this.f_19804_.m_135381_(CASTER_UUID, Optional.of(caster.m_20148_()));
            this.cachedCaster = caster;
        } else {
            this.f_19804_.m_135381_(CASTER_UUID, Optional.empty());
            this.cachedCaster = null;
        }
    }

    public boolean isAzure() {
        return (Boolean)this.f_19804_.m_135370_(IS_AZURE);
    }

    public void setAzure(boolean isAzure) {
        this.f_19804_.m_135381_(IS_AZURE, (Object)isAzure);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getYOffset() {
        return ((Float)this.f_19804_.m_135370_(Y_OFFSET)).floatValue();
    }

    public void setYOffset(float offset) {
        this.f_19804_.m_135381_(Y_OFFSET, (Object)Float.valueOf(offset));
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    protected void m_7378_(CompoundTag compound) {
        this.setAzure(compound.m_128471_("IsAzure"));
        this.setDamage(compound.m_128457_("Damage"));
        this.setYOffset(compound.m_128457_("YOffset"));
        if (compound.m_128403_("TargetUUID")) {
            this.f_19804_.m_135381_(TARGET_UUID, Optional.of(compound.m_128342_("TargetUUID")));
        }
        if (compound.m_128403_("CasterUUID")) {
            this.f_19804_.m_135381_(CASTER_UUID, Optional.of(compound.m_128342_("CasterUUID")));
        }
        this.damagePerTick = this.getDamage() / 30.0f;
    }

    protected void m_7380_(CompoundTag compound) {
        Optional casterUUID;
        compound.m_128379_("IsAzure", this.isAzure());
        compound.m_128350_("Damage", this.getDamage());
        compound.m_128350_("YOffset", this.getYOffset());
        Optional targetUUID = (Optional)this.f_19804_.m_135370_(TARGET_UUID);
        if (targetUUID.isPresent()) {
            compound.m_128362_("TargetUUID", (UUID)targetUUID.get());
        }
        if ((casterUUID = (Optional)this.f_19804_.m_135370_(CASTER_UUID)).isPresent()) {
            compound.m_128362_("CasterUUID", (UUID)casterUUID.get());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static void applyMarkToEntity(Entity target, Entity caster, boolean isAzure, float damage, float yOffset) {
        if (target == null || target.m_9236_().f_46443_) {
            return;
        }
        GalenaMarkEntity.removeMarkFromEntity(target);
        GalenaMarkEntity markEntity = new GalenaMarkEntity(target.m_9236_(), target, caster, isAzure, damage, yOffset);
        target.m_9236_().m_7967_((Entity)markEntity);
    }

    public static void removeMarkFromEntity(Entity target) {
        if (target == null) {
            return;
        }
        AABB searchArea = new AABB(target.m_20185_() - 0.1, target.m_20186_() - 0.1, target.m_20189_() - 0.1, target.m_20185_() + 0.1, target.m_20186_() + (double)target.m_20206_() + 2.0, target.m_20189_() + 0.1);
        List marks = target.m_9236_().m_45976_(GalenaMarkEntity.class, searchArea);
        for (GalenaMarkEntity mark : marks) {
            Entity markTarget = mark.getTarget();
            if (markTarget == null || !markTarget.equals((Object)target)) continue;
            mark.m_146870_();
        }
    }

    public static boolean hasMarkOnEntity(Entity target) {
        if (target == null) {
            return false;
        }
        AABB searchArea = new AABB(target.m_20185_() - 0.1, target.m_20186_() - 0.1, target.m_20189_() - 0.1, target.m_20185_() + 0.1, target.m_20186_() + (double)target.m_20206_() + 2.0, target.m_20189_() + 0.1);
        List marks = target.m_9236_().m_45976_(GalenaMarkEntity.class, searchArea);
        for (GalenaMarkEntity mark : marks) {
            Entity markTarget = mark.getTarget();
            if (markTarget == null || !markTarget.equals((Object)target)) continue;
            return true;
        }
        return false;
    }

    public static List<Entity> scanForMarkedEntities(Level level, double x, double y, double z, double radius, boolean isAzure) {
        ArrayList<Entity> markedEntities = new ArrayList<Entity>();
        AABB searchArea = new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List marks = level.m_45976_(GalenaMarkEntity.class, searchArea);
        for (GalenaMarkEntity mark : marks) {
            Entity target;
            if (mark.isAzure() != isAzure || (target = mark.getTarget()) == null || markedEntities.contains(target)) continue;
            markedEntities.add(target);
        }
        return markedEntities;
    }
}

