/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.elemental_interactions;

import com.gametechbc.traveloptics.api.utils.TOCurioUtils;
import com.gametechbc.traveloptics.entity.projectiles.BlizzardAoe;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.item.armor.RiptideSovereignArmorItem;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CryostormReaction {
    private static final int WET_BLIZZARD_COOLDOWN_TICKS = 160;
    private static final Map<UUID, Long> wetBlizzardCooldownMap = new HashMap<UUID, Long>();

    public static void triggerWetBlizzard(Level world, LivingEntity caster, LivingEntity victim) {
        long lastTrigger;
        if (world.f_46443_) {
            return;
        }
        UUID casterUUID = caster.m_20148_();
        long currentTick = world.m_46467_();
        if (wetBlizzardCooldownMap.containsKey(casterUUID) && currentTick - (lastTrigger = wetBlizzardCooldownMap.get(casterUUID).longValue()) < 160L) {
            return;
        }
        wetBlizzardCooldownMap.put(casterUUID, currentTick);
        BlizzardAoe blizzard = new BlizzardAoe(world);
        blizzard.m_6034_(victim.m_20185_(), victim.m_20186_(), victim.m_20189_());
        blizzard.m_5602_((Entity)caster);
        blizzard.setRadius(CryostormReaction.getBlizzardRadius(caster));
        blizzard.setDamage(CryostormReaction.calculateWetBlizzardDamage(caster, victim));
        blizzard.setDuration(100);
        blizzard.setSlownessAmplifier(2);
        world.m_7967_((Entity)blizzard);
        CryostormReaction.removeWetEffect(victim);
    }

    private static float calculateWetBlizzardDamage(LivingEntity caster, LivingEntity victim) {
        float baseDamage = 6.5f;
        MobEffectInstance wetEffect = victim.m_21124_((MobEffect)TravelopticsEffects.WET.get());
        int wetAmplifier = wetEffect != null ? wetEffect.m_19564_() : 0;
        float wetBonusDamage = (float)wetAmplifier * 2.0f;
        double iceSpellPower = caster.m_21133_((Attribute)AttributeRegistry.ICE_SPELL_POWER.get());
        float blizzardTotalDamage = (baseDamage + wetBonusDamage) * (float)iceSpellPower;
        blizzardTotalDamage /= 10.0f;
        blizzardTotalDamage = CryostormReaction.applyCryostormDamageBonus(caster, blizzardTotalDamage);
        return blizzardTotalDamage;
    }

    private static void removeWetEffect(LivingEntity entity) {
        if (entity.m_21023_((MobEffect)TravelopticsEffects.WET.get())) {
            entity.m_21195_((MobEffect)TravelopticsEffects.WET.get());
        }
    }

    private static boolean isHoldingStormEmpressStaff(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        return mainHand.m_150930_((Item)TravelopticsItems.STAFF_OF_THE_STORM_EMPRESS.get()) || offHand.m_150930_((Item)TravelopticsItems.STAFF_OF_THE_STORM_EMPRESS.get());
    }

    public static boolean hasCryostormEnabled(LivingEntity caster) {
        if (caster instanceof Player) {
            Player player = (Player)caster;
            return RiptideSovereignArmorItem.isWearingFullSet(player) || TOCurioUtils.getWearingCurio(caster, (Item)TravelopticsItems.CRYOSTORM_BRACELET.get());
        }
        return TOCurioUtils.getWearingCurio(caster, (Item)TravelopticsItems.CRYOSTORM_BRACELET.get());
    }

    public static float applyCryostormDamageBonus(LivingEntity caster, float baseDamage) {
        if (CryostormReaction.isHoldingStormEmpressStaff(caster)) {
            return baseDamage * 1.15f;
        }
        return baseDamage;
    }

    public static float getBlizzardRadius(LivingEntity caster) {
        if (CryostormReaction.isHoldingStormEmpressStaff(caster)) {
            return 6.0f;
        }
        return 4.5f;
    }
}

