/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.effects.flames_reborn;

import com.gametechbc.traveloptics.api.particle.ParticleDirection;
import com.gametechbc.traveloptics.api.particle.SphereParticleManager;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="traveloptics")
public class FlamesRebornHandler {
    private static final Map<UUID, RecordedPosition> recordedPositions = new HashMap<UUID, RecordedPosition>();

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)TravelopticsEffects.FLAMES_REBORN.get())) {
            event.setCanceled(true);
            entity.m_21195_((MobEffect)TravelopticsEffects.FLAMES_REBORN.get());
            FlamesRebornHandler.clearRecordedPosition(entity);
        }
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() == TravelopticsEffects.FLAMES_REBORN.get()) {
            System.out.println("FLAMES_REBORN added! Recording position...");
            FlamesRebornHandler.recordPosition(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffect() == TravelopticsEffects.FLAMES_REBORN.get()) {
            FlamesRebornHandler.handleEffectEnd(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        if (event.getEffectInstance().m_19544_() == TravelopticsEffects.FLAMES_REBORN.get()) {
            FlamesRebornHandler.handleEffectEnd(event.getEntity());
        }
    }

    public static void recordPosition(LivingEntity entity) {
        if (!entity.m_9236_().f_46443_) {
            Vec3 position = entity.m_20182_();
            ResourceKey dimension = entity.m_9236_().m_46472_();
            Vec3 lookDirection = entity.m_20154_();
            float health = entity.m_21223_();
            recordedPositions.put(entity.m_20148_(), new RecordedPosition(position, (ResourceKey<Level>)dimension, lookDirection, health));
        }
    }

    private static void handleEffectEnd(LivingEntity entity) {
        SphereParticleManager.spawnParticles(entity.m_9236_(), (Entity)entity, 35, ParticleHelper.FIRE, ParticleDirection.INWARD, 3.0);
        FlamesRebornHandler.teleportEntityToRecordedPosition(entity);
        RecordedPosition recordedPosition = FlamesRebornHandler.getRecordedPosition(entity.m_20148_());
        if (recordedPosition != null) {
            SphereParticleManager.spawnParticles(entity.m_9236_(), (Entity)entity, 50, ParticleHelper.FIRE, ParticleDirection.OUTWARD, 3.0);
            entity.m_9236_().m_6269_(null, (Entity)entity, (SoundEvent)TravelopticsSounds.FLAMES_REBORN_REVIVE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!entity.m_9236_().f_46443_) {
                CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(15, entity.m_20182_(), 15.0f));
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                String[] messages = new String[]{"quote.traveloptics.flames_reborn_revive_1", "quote.traveloptics.flames_reborn_revive_2", "quote.traveloptics.flames_reborn_revive_3", "quote.traveloptics.flames_reborn_revive_4", "quote.traveloptics.flames_reborn_revive_5", "quote.traveloptics.flames_reborn_revive_6"};
                String selectedMessage = messages[player.m_217043_().m_188503_(messages.length)];
                player.m_5661_((Component)Component.m_237115_((String)selectedMessage).m_130938_(style -> style.m_178520_(16766783)), true);
            }
        }
        FlamesRebornHandler.clearRecordedPosition(entity);
    }

    public static void teleportEntityToRecordedPosition(LivingEntity entity) {
        Level level;
        final RecordedPosition recordedPosition = recordedPositions.get(entity.m_20148_());
        if (recordedPosition != null && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel currentLevel = (ServerLevel)level;
            ResourceKey<Level> targetDimension = recordedPosition.dimension;
            final Vec3 targetPosition = recordedPosition.position;
            final float targetYaw = entity.m_146908_();
            final float targetPitch = entity.m_146909_();
            if (!currentLevel.m_46472_().equals(targetDimension)) {
                ServerLevel targetLevel = currentLevel.m_7654_().m_129880_(targetDimension);
                if (targetLevel != null) {
                    Entity result = entity.changeDimension(targetLevel, new ITeleporter(){

                        public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
                            return new PortalInfo(targetPosition, Vec3.f_82478_, targetYaw, targetPitch);
                        }

                        public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                            entity = repositionEntity.apply(false);
                            if (entity != null) {
                                entity.m_7678_(targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_, targetYaw, targetPitch);
                                entity.m_5616_((float)recordedPosition.lookDirection.f_82480_);
                            }
                            return entity;
                        }

                        public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
                            return false;
                        }
                    });
                    if (result instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)result;
                        living.m_21153_(recordedPosition.health);
                    }
                } else {
                    System.err.println("Target dimension not found: " + String.valueOf(targetDimension.m_135782_()));
                }
            } else {
                entity.m_6021_(targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_);
                entity.m_146922_(targetYaw);
                entity.m_146926_(targetPitch);
                entity.m_5616_((float)recordedPosition.lookDirection.f_82480_);
                entity.m_21153_(recordedPosition.health);
            }
        }
    }

    public static void clearRecordedPosition(LivingEntity entity) {
        recordedPositions.remove(entity.m_20148_());
    }

    public static RecordedPosition getRecordedPosition(UUID entityId) {
        return recordedPositions.get(entityId);
    }

    public static class RecordedPosition {
        final Vec3 position;
        final ResourceKey<Level> dimension;
        final Vec3 lookDirection;
        final float health;

        RecordedPosition(Vec3 position, ResourceKey<Level> dimension, Vec3 lookDirection, float health) {
            this.position = position;
            this.dimension = dimension;
            this.lookDirection = lookDirection;
            this.health = health;
        }
    }
}

