/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.effects;

import com.gametechbc.traveloptics.api.utils.TOCurioUtils;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.init.TravelopticsMessages;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.network.SpectralBlinkActivationPacket;
import com.gametechbc.traveloptics.network.SpectralBlinkTeleportPacket;
import com.gametechbc.traveloptics.util.TravelopticsTags;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpectralBlinkEffect
extends MobEffect {
    private static final double TARGETING_FORGIVENESS = 1.2;
    private static final int MAX_DURATION = 60;

    public SpectralBlinkEffect() {
        super(MobEffectCategory.BENEFICIAL, 0xFFFFFF);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Level world = entity.m_9236_();
        MobEffectInstance effectInstance = entity.m_21124_((MobEffect)this);
        if (effectInstance == null) {
            return;
        }
        int duration = effectInstance.m_19557_();
        int level = amplifier + 1;
        double range = 1.0 + (double)level;
        if (duration == 60) {
            world.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.SPECTRAL_BLINK_CHARGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (duration > 60) {
            entity.m_21195_((MobEffect)this);
            entity.m_7292_(new MobEffectInstance((MobEffect)this, 60, amplifier, false, true));
            return;
        }
        if (duration % 2 == 0 && entity instanceof Player) {
            Player player = (Player)entity;
            this.notifyCurrentTarget(player, range, world);
        }
        if (duration % 5 == 0) {
            for (Entity nearbyEntity : world.m_45933_((Entity)entity, entity.m_20191_().m_82400_(range))) {
                if (!(nearbyEntity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)nearbyEntity;
                if (nearbyEntity == entity) continue;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 10, 0, false, false));
            }
        }
        if (duration == 1) {
            this.handleBlinkLogic(entity, amplifier, range, world);
        }
    }

    private void handleBlinkLogic(LivingEntity entity, int amplifier, double range, Level world) {
        boolean hasSpectralShift = TOCurioUtils.getWearingCurio(entity, (Item)TravelopticsItems.AMULET_OF_SPECTRAL_SHIFT.get());
        boolean teleportTargetToPlayer = entity.m_6047_() && hasSpectralShift;
        this.executeTeleport(entity, range, world, teleportTargetToPlayer);
    }

    private void executeTeleport(LivingEntity entity, double range, Level world, boolean teleportTargetToPlayer) {
        EntityHitResult hitResult = this.findTargetEntity(entity, range, world);
        if (hitResult != null && hitResult.m_6662_() == HitResult.Type.ENTITY) {
            Entity targetEntity = hitResult.m_82443_();
            if (this.isBlacklisted(targetEntity, teleportTargetToPlayer)) {
                this.handleBlacklistNotification(entity, targetEntity, teleportTargetToPlayer);
                return;
            }
            if (teleportTargetToPlayer) {
                Vec3 playerPos = entity.m_20182_();
                targetEntity.m_6021_(playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_);
                this.notifyTeleport(entity, targetEntity, true);
            } else {
                Vec3 targetPos = targetEntity.m_20182_();
                entity.m_6021_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
                this.notifyTeleport(entity, targetEntity, false);
            }
            this.playSuccessEffects(world, entity);
        } else {
            this.playFailedBlinkPostEffects(world, (Entity)entity);
        }
    }

    private EntityHitResult findTargetEntity(LivingEntity entity, double range, Level world) {
        Vec3 startVec = entity.m_20299_(1.0f);
        Vec3 viewVec = entity.m_20154_();
        Vec3 endVec = startVec.m_82549_(viewVec.m_82490_(range));
        AABB boundingBox = entity.m_20191_().m_82369_(viewVec.m_82490_(range)).m_82400_(1.0);
        return this.getForgivingEntityHitResult(world, entity, startVec, endVec, boundingBox);
    }

    private boolean isBlacklisted(Entity target, boolean isSpectralShift) {
        if (isSpectralShift) {
            return target.m_6095_().m_204039_(TravelopticsTags.SPECTRAL_SHIFT_BLACKLIST);
        }
        return target.m_6095_().m_204039_(TravelopticsTags.SPECTRAL_BLINK_BLACKLIST);
    }

    private void handleBlacklistNotification(LivingEntity entity, Entity target, boolean isSpectralShift) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String messageKey = isSpectralShift ? "effect.traveloptics.spectral_blink.cannot_teleport_entity" : "effect.traveloptics.spectral_blink.cannot_teleport_to";
            player.m_5661_((Component)Component.m_237110_((String)messageKey, (Object[])new Object[]{target.m_7755_()}).m_130940_(ChatFormatting.RED), true);
        }
    }

    private void notifyTeleport(LivingEntity entity, Entity target, boolean teleportedToPlayer) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (teleportedToPlayer) {
                player.m_5661_((Component)Component.m_237110_((String)"effect.traveloptics.spectral_blink.entity_teleported", (Object[])new Object[]{target.m_7755_()}), true);
            } else {
                player.m_5661_((Component)Component.m_237110_((String)"effect.traveloptics.spectral_blink.success", (Object[])new Object[]{target.m_7755_()}), true);
            }
        }
    }

    private void notifyCurrentTarget(Player player, double range, Level world) {
        EntityHitResult hitResult = this.findTargetEntity((LivingEntity)player, range, world);
        if (hitResult != null && hitResult.m_6662_() == HitResult.Type.ENTITY) {
            Entity targetEntity = hitResult.m_82443_();
            boolean hasSpectralShift = TOCurioUtils.getWearingCurio((LivingEntity)player, (Item)TravelopticsItems.AMULET_OF_SPECTRAL_SHIFT.get());
            boolean isCrouching = player.m_6047_();
            boolean isBlacklisted = this.isBlacklisted(targetEntity, isCrouching && hasSpectralShift);
            if (isBlacklisted) {
                player.m_5661_((Component)Component.m_237110_((String)"effect.traveloptics.spectral_blink.target_blacklisted", (Object[])new Object[]{targetEntity.m_7755_()}).m_130940_(ChatFormatting.RED), true);
            } else if (isCrouching && hasSpectralShift) {
                player.m_5661_((Component)Component.m_237110_((String)"effect.traveloptics.spectral_blink.targeting_pull", (Object[])new Object[]{targetEntity.m_7755_()}).m_130940_(ChatFormatting.AQUA), true);
            } else {
                player.m_5661_((Component)Component.m_237110_((String)"effect.traveloptics.spectral_blink.targeting", (Object[])new Object[]{targetEntity.m_7755_()}).m_130940_(ChatFormatting.GREEN), true);
            }
        }
    }

    private void playSuccessEffects(Level world, LivingEntity entity) {
        world.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.SPECTRAL_BLINK_SUCCESS.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            TravelopticsMessages.sendToPlayer(new SpectralBlinkTeleportPacket(), serverPlayer);
        }
    }

    private void playFailedBlinkPostEffects(Level world, Entity entity) {
        world.m_5594_(null, entity.m_20183_(), (SoundEvent)TravelopticsSounds.SPECTRAL_BLINK_FAILED.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237115_((String)"effect.traveloptics.spectral_blink.missed").m_130940_(ChatFormatting.RED), true);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            TravelopticsMessages.sendToPlayer(new SpectralBlinkActivationPacket(), serverPlayer);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    private EntityHitResult getForgivingEntityHitResult(Level world, LivingEntity entity, Vec3 startVec, Vec3 endVec, AABB boundingBox) {
        EntityHitResult bestResult = null;
        double closestDistance = Double.MAX_VALUE;
        for (Entity targetEntity : world.m_6249_((Entity)entity, boundingBox, e -> !e.m_5833_() && e.m_6087_())) {
            double distance;
            AABB entityBoundingBox = targetEntity.m_20191_().m_82400_((double)targetEntity.m_6143_() + 1.2);
            if (!entityBoundingBox.m_82371_(startVec, endVec).isPresent() || !((distance = startVec.m_82554_(targetEntity.m_20191_().m_82399_())) < closestDistance)) continue;
            closestDistance = distance;
            bestResult = new EntityHitResult(targetEntity);
        }
        return bestResult;
    }
}

