/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.util;

import com.alaharranhonor.swem.forge.util.ILockable;
import com.alaharranhonor.swem.forge.util.ILockableContainer;
import com.alaharranhonor.swem.forge.util.NameTagLock;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class TagLockContainer
implements Container,
ILockable {
    private final ILockableContainer parent;
    private final int size;
    private final NonNullList<NameTagLock> locks;

    public TagLockContainer(ILockableContainer parent, int size) {
        this.parent = parent;
        this.size = size;
        this.locks = NonNullList.m_122780_((int)size, (Object)new NameTagLock());
    }

    public TagLockContainer(ILockableContainer parent, NameTagLock ... locks) {
        this.parent = parent;
        this.size = locks.length;
        this.locks = NonNullList.m_122783_((Object)new NameTagLock(), (Object[])locks);
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        return pStack.m_150930_(Items.f_42656_);
    }

    public ItemStack m_8020_(int pIndex) {
        return pIndex >= 0 && pIndex < this.locks.size() ? ((NameTagLock)this.locks.get(pIndex)).getNameTag() : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        ItemStack itemstack = ((NameTagLock)this.locks.get(pIndex)).getNameTag();
        if (!itemstack.m_41619_()) {
            this.locks.set(pIndex, (Object)new NameTagLock());
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int pIndex) {
        ItemStack itemstack = ((NameTagLock)this.locks.get(pIndex)).getNameTag();
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.locks.set(pIndex, (Object)new NameTagLock());
        return itemstack;
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        this.locks.set(pIndex, (Object)new NameTagLock(pStack));
        if (!pStack.m_41619_() && pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public void m_6596_() {
    }

    public int m_6643_() {
        return this.size;
    }

    public boolean m_7983_() {
        for (NameTagLock lock : this.locks) {
            if (lock.getNameTag().m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean m_6542_(Player pPlayer) {
        return true;
    }

    public void m_6211_() {
        this.locks.clear();
        this.m_6596_();
    }

    public String toString() {
        return this.locks.stream().filter(lock -> !lock.getNameTag().m_41619_()).toList().toString();
    }

    public void fromTag(ListTag pContainerNbt) {
        for (int i = 0; i < pContainerNbt.size(); ++i) {
            CompoundTag lockTag = pContainerNbt.m_128728_(i);
            NameTagLock lock = new NameTagLock();
            lock.deserializeNBT(lockTag);
            this.locks.set(i, (Object)lock);
        }
    }

    public ListTag createTag() {
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.m_6643_(); ++i) {
            NameTagLock lock = (NameTagLock)this.locks.get(i);
            listtag.add((Object)lock.serializeNBT());
        }
        return listtag;
    }

    @Override
    public boolean canAccess(Player player) {
        if (this.m_7983_()) {
            return true;
        }
        for (NameTagLock lock : this.locks) {
            if (!lock.canAccess(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canModifyLock(Player player) {
        return this.parent.canModifyLocks(player);
    }

    public void setLock(int slot, NameTagLock lock) {
        this.locks.set(slot, (Object)lock);
    }
}

