/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.util;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface DualDyeableItem {
    public static final String TAG_PRIMARY_COLOR = "color_primary";
    public static final String TAG_SECONDARY_COLOR = "color_secondary";
    public static final String TAG_DISPLAY = "display";
    public static final int DEFAULT_PRIMARY_COLOR = -1;
    public static final int DEFAULT_SECONDARY_COLOR = -1;

    public static ItemStack dyeItem(ItemStack pStack, List<DyeItem> primaryColors, List<DyeItem> secondaryColors) {
        ItemStack itemstack = ItemStack.f_41583_;
        int[] primary = new int[3];
        int primaryMax = 0;
        int primaryStacks = 0;
        int[] secondary = new int[3];
        int secondaryMax = 0;
        int secondaryStacks = 0;
        DualDyeableItem dyeable = null;
        Item item = pStack.m_41720_();
        if (item instanceof DualDyeableItem) {
            int b;
            int g;
            float b2;
            float g2;
            float r;
            int color;
            dyeable = (DualDyeableItem)item;
            itemstack = pStack.m_41777_();
            itemstack.m_41764_(1);
            if (dyeable.hasCustomPrimary(pStack)) {
                color = dyeable.getPrimary(itemstack);
                r = (float)(color >> 16 & 0xFF) / 255.0f;
                g2 = (float)(color >> 8 & 0xFF) / 255.0f;
                b2 = (float)(color & 0xFF) / 255.0f;
                primaryMax += (int)(Math.max(r, Math.max(g2, b2)) * 255.0f);
                primary[0] = primary[0] + (int)(r * 255.0f);
                primary[1] = primary[1] + (int)(g2 * 255.0f);
                primary[2] = primary[2] + (int)(b2 * 255.0f);
                ++primaryStacks;
            }
            if (dyeable.hasCustomSecondary(pStack)) {
                color = dyeable.getSecondary(itemstack);
                r = (float)(color >> 16 & 0xFF) / 255.0f;
                g2 = (float)(color >> 8 & 0xFF) / 255.0f;
                b2 = (float)(color & 0xFF) / 255.0f;
                secondaryMax += (int)(Math.max(r, Math.max(g2, b2)) * 255.0f);
                secondary[0] = secondary[0] + (int)(r * 255.0f);
                secondary[1] = secondary[1] + (int)(g2 * 255.0f);
                secondary[2] = secondary[2] + (int)(b2 * 255.0f);
                ++secondaryStacks;
            }
            for (DyeItem dye : primaryColors) {
                float[] dyeColors = dye.m_41089_().m_41068_();
                int r2 = (int)(dyeColors[0] * 255.0f);
                g = (int)(dyeColors[1] * 255.0f);
                b = (int)(dyeColors[2] * 255.0f);
                primaryMax += Math.max(r2, Math.max(g, b));
                primary[0] = primary[0] + r2;
                primary[1] = primary[1] + g;
                primary[2] = primary[2] + b;
                ++primaryStacks;
            }
            for (DyeItem dye : secondaryColors) {
                float[] dyeColors = dye.m_41089_().m_41068_();
                int r3 = (int)(dyeColors[0] * 255.0f);
                g = (int)(dyeColors[1] * 255.0f);
                b = (int)(dyeColors[2] * 255.0f);
                secondaryMax += Math.max(r3, Math.max(g, b));
                secondary[0] = secondary[0] + r3;
                secondary[1] = secondary[1] + g;
                secondary[2] = secondary[2] + b;
                ++secondaryStacks;
            }
        }
        if (dyeable == null) {
            return ItemStack.f_41583_;
        }
        if (primaryStacks > 0) {
            dyeable.setPrimary(itemstack, DualDyeableItem.getColorMix(primary, primaryMax, primaryStacks));
        }
        if (secondaryStacks > 0) {
            dyeable.setSecondary(itemstack, DualDyeableItem.getColorMix(secondary, secondaryMax, secondaryStacks));
        }
        return itemstack;
    }

    public static int getColorMix(int[] colors, int max, int stacks) {
        int red = colors[0] / stacks;
        int green = colors[1] / stacks;
        int blue = colors[2] / stacks;
        float strength = (float)max / (float)stacks;
        float maxColor = Math.max(red, Math.max(green, blue));
        red = (int)((float)red * strength / maxColor);
        green = (int)((float)green * strength / maxColor);
        blue = (int)((float)blue * strength / maxColor);
        int color = (red << 8) + green;
        color = (color << 8) + blue;
        return color;
    }

    default public int getDefaultPrimaryColor() {
        return -1;
    }

    default public int getDefaultSecondaryColor() {
        return -1;
    }

    default public boolean hasCustomPrimary(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41737_(TAG_DISPLAY);
        return compoundtag != null && compoundtag.m_128425_(TAG_PRIMARY_COLOR, 99);
    }

    default public boolean hasCustomSecondary(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41737_(TAG_DISPLAY);
        return compoundtag != null && compoundtag.m_128425_(TAG_SECONDARY_COLOR, 99);
    }

    default public int getPrimary(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41737_(TAG_DISPLAY);
        return compoundtag != null && compoundtag.m_128425_(TAG_PRIMARY_COLOR, 99) ? compoundtag.m_128451_(TAG_PRIMARY_COLOR) : this.getDefaultPrimaryColor();
    }

    default public int getSecondary(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41737_(TAG_DISPLAY);
        return compoundtag != null && compoundtag.m_128425_(TAG_SECONDARY_COLOR, 99) ? compoundtag.m_128451_(TAG_SECONDARY_COLOR) : this.getDefaultSecondaryColor();
    }

    default public void clearColor(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41737_(TAG_DISPLAY);
        if (compoundtag != null) {
            if (compoundtag.m_128441_(TAG_PRIMARY_COLOR)) {
                compoundtag.m_128473_(TAG_PRIMARY_COLOR);
            }
            if (compoundtag.m_128441_(TAG_SECONDARY_COLOR)) {
                compoundtag.m_128473_(TAG_SECONDARY_COLOR);
            }
        }
    }

    default public void setPrimary(ItemStack stack, int primary) {
        stack.m_41698_(TAG_DISPLAY).m_128405_(TAG_PRIMARY_COLOR, primary);
    }

    default public void setSecondary(ItemStack stack, int secondary) {
        stack.m_41698_(TAG_DISPLAY).m_128405_(TAG_SECONDARY_COLOR, secondary);
    }
}

