/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.tileentity;

import com.alaharranhonor.swem.forge.community.TackType;
import com.alaharranhonor.swem.forge.container.TagLockMenu;
import com.alaharranhonor.swem.forge.items.tack.TackItem;
import com.alaharranhonor.swem.forge.keys.Keys;
import com.alaharranhonor.swem.forge.registry.BlockEntitySetup;
import com.alaharranhonor.swem.forge.util.ILockableContainer;
import com.alaharranhonor.swem.forge.util.NameTagLock;
import com.alaharranhonor.swem.forge.util.PermissionNodes;
import com.alaharranhonor.swem.forge.util.TagLockContainer;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HorseArmorRackBE
extends BlockEntity
implements GeoBlockEntity,
MenuProvider,
ILockableContainer {
    protected final ItemStackHandler itemHandler = this.createHandler();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this, (boolean)true);
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private UUID ownerId;
    private String ownerName;
    private final TagLockContainer lockContainer = new TagLockContainer(this, 5){

        @Override
        public void m_6596_() {
            HorseArmorRackBE.this.m_6596_();
        }
    };

    public HorseArmorRackBE(BlockPos p_155630_, BlockState p_155631_) {
        super((BlockEntityType)BlockEntitySetup.HORSE_ARMOR_RACK_BLOCK_ENTITY.get(), p_155630_, p_155631_);
    }

    public boolean canAccess(Player player) {
        if (player.m_20148_().equals(this.ownerId)) {
            return true;
        }
        if (Keys.hasPermission(player, PermissionNodes.CAN_ACCESS)) {
            return true;
        }
        return this.lockContainer.canAccess(player);
    }

    public void setOwner(Player player) {
        this.ownerId = player.m_20148_();
        this.ownerName = player.m_5446_().getString();
    }

    public boolean hasOwner() {
        return this.ownerId != null;
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("Locks", (Tag)this.lockContainer.createTag());
        if (this.ownerId != null) {
            tag.m_128362_("Owner", this.ownerId);
        }
        if (this.ownerName != null) {
            tag.m_128359_("OwnerName", this.ownerName);
        }
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("inv")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("inv"));
        }
        if (tag.m_128441_("Lock")) {
            NameTagLock lock = new NameTagLock();
            lock.deserializeNBT(tag.m_128469_("Lock"));
            this.lockContainer.setLock(0, lock);
        } else if (tag.m_128441_("Locks")) {
            this.lockContainer.fromTag(tag.m_128437_("Locks", 10));
        }
        if (tag.m_128441_("Owner")) {
            this.ownerId = tag.m_128342_("Owner");
        }
        if (tag.m_128441_("OwnerName")) {
            this.ownerName = tag.m_128461_("OwnerName");
        }
        super.m_142466_(tag);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    @javax.annotation.Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                HorseArmorRackBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return TackType.HORSE_ARMOR.is(stack);
                }
                return TackType.SADDLE.is(stack) && TackItem.as(stack).getData().canWearArmor();
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.itemHandler != null) {
            this.handler.invalidate();
        }
    }

    public void dropItems() {
        int i;
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i) == ItemStack.f_41583_) continue;
            ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), this.itemHandler.getStackInSlot(i));
            RandomSource random = this.f_58857_.m_213780_();
            entity.m_20334_(random.m_188583_() * (double)0.05f, random.m_188583_() * (double)0.05f + (double)0.2f, random.m_188583_() * (double)0.05f);
            this.f_58857_.m_7967_((Entity)entity);
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
        for (i = 0; i < this.lockContainer.m_6643_(); ++i) {
            ItemStack item = this.lockContainer.m_8020_(i);
            if (item.m_41619_()) continue;
            ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), item);
            RandomSource random = this.f_58857_.m_213780_();
            entity.m_20334_(random.m_188583_() * (double)0.05f, random.m_188583_() * (double)0.05f + (double)0.2f, random.m_188583_() * (double)0.05f);
            this.f_58857_.m_7967_((Entity)entity);
            this.lockContainer.m_6836_(i, ItemStack.f_41583_);
        }
    }

    @Override
    public TagLockContainer getLocks() {
        return this.lockContainer;
    }

    @Override
    public boolean canModifyLocks(Player player) {
        return player.m_20148_().equals(this.ownerId) || Keys.hasPermission(player, PermissionNodes.CAN_ACCESS);
    }

    public Component m_5446_() {
        if (this.ownerName == null) {
            Player player = this.f_58857_.m_46003_(this.ownerId);
            if (player == null) {
                return Component.m_237113_((String)"Unknown");
            }
            this.ownerName = player.m_5446_().getString();
        }
        return Component.m_237113_((String)this.ownerName);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new TagLockMenu(pContainerId, pPlayerInventory, this.getLocks());
    }

    public <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

