/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.tileentity;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.tileentity.HorseFeeder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class FeederBlockEntity
extends BlockEntity
implements HorseFeeder {
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);

    protected FeederBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        this.itemHandler.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public IItemHandler getHandler() {
        return (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().get();
    }

    public void m_7651_() {
        super.m_7651_();
        this.handler.invalidate();
    }

    protected abstract ItemStackHandler createHandler();

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean isEmpty(int slot) {
        return this.itemHandler.getStackInSlot(slot).m_41619_();
    }

    @Override
    public ItemStack eat(int slot, SWEMHorseEntityBase horse) {
        ItemStack extractedItemStack = this.itemHandler.extractItem(slot, 1, false);
        horse.getNeeds().getHunger().feedWith(extractedItemStack);
        if (horse.isBreedingFood(extractedItemStack)) {
            horse.handleEatingBreedingFood(null, extractedItemStack);
        }
        return extractedItemStack;
    }

    @Override
    public ItemStack peekStack(int slot) {
        return this.itemHandler.getStackInSlot(slot).m_41777_();
    }
}

