/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.registry;

import com.alaharranhonor.swem.forge.entities.Tackable;
import com.alaharranhonor.swem.forge.registry.ItemSetup;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class DispenseBehaviorSetup {
    static OptionalDispenseItemBehavior BLANKET_BEHAVIOR = new OptionalDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            List list = source.m_7727_().m_6443_(LivingEntity.class, new AABB(blockpos), p_123527_ -> {
                if (!(p_123527_ instanceof Tackable)) {
                    return false;
                }
                Tackable saddleable = (Tackable)p_123527_;
                return !saddleable.hasBlanket() && saddleable.hasHalter() && saddleable.canReceiveTack(null);
            });
            if (!list.isEmpty()) {
                ((Tackable)list.get(0)).equipTack(SoundSource.BLOCKS, stack, null);
                stack.m_41774_(1);
                this.m_123573_(true);
                return stack;
            }
            return super.m_7498_(source, stack);
        }
    };
    static OptionalDispenseItemBehavior SADDLE_BEHAVIOR = new OptionalDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            List list = source.m_7727_().m_6443_(LivingEntity.class, new AABB(blockpos), p_123527_ -> {
                if (!(p_123527_ instanceof Tackable)) {
                    return false;
                }
                Tackable saddleable = (Tackable)p_123527_;
                return !saddleable.isWearingPastureBlanket() && !saddleable.hasSaddle() && saddleable.canEquipSaddle() && saddleable.canReceiveTack(null);
            });
            if (!list.isEmpty()) {
                ((Tackable)list.get(0)).equipTack(SoundSource.BLOCKS, stack, null);
                stack.m_41774_(1);
                this.m_123573_(true);
                return stack;
            }
            return super.m_7498_(source, stack);
        }
    };
    static OptionalDispenseItemBehavior LEG_WRAPS_BEHAVIOR = new OptionalDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            List list = source.m_7727_().m_6443_(LivingEntity.class, new AABB(blockpos), p_123527_ -> {
                if (!(p_123527_ instanceof Tackable)) {
                    return false;
                }
                Tackable saddleable = (Tackable)p_123527_;
                return !saddleable.hasLegWraps() && saddleable.hasHalter() && saddleable.canReceiveTack(null);
            });
            if (!list.isEmpty()) {
                ((Tackable)list.get(0)).equipTack(SoundSource.BLOCKS, stack, null);
                stack.m_41774_(1);
                this.m_123573_(true);
                return stack;
            }
            return super.m_7498_(source, stack);
        }
    };
    static OptionalDispenseItemBehavior GIRTH_STRAP_BEHAVIOR = new OptionalDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            List list = source.m_7727_().m_6443_(LivingEntity.class, new AABB(blockpos), p_123527_ -> {
                if (!(p_123527_ instanceof Tackable)) {
                    return false;
                }
                Tackable saddleable = (Tackable)p_123527_;
                return !saddleable.hasGirthStrap() && saddleable.canEquipGirthStrap() && !saddleable.isWearingPastureBlanket() && saddleable.canReceiveTack(null);
            });
            if (!list.isEmpty()) {
                ((Tackable)list.get(0)).equipTack(SoundSource.BLOCKS, stack, null);
                stack.m_41774_(1);
                this.m_123573_(true);
                return stack;
            }
            return super.m_7498_(source, stack);
        }
    };
    static OptionalDispenseItemBehavior HALTER_BEHAVIOR = new OptionalDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            List list = source.m_7727_().m_6443_(LivingEntity.class, new AABB(blockpos), p_123527_ -> {
                if (!(p_123527_ instanceof Tackable)) {
                    return false;
                }
                Tackable saddleable = (Tackable)p_123527_;
                return !saddleable.hasHalter() && saddleable.canReceiveTack(null);
            });
            if (!list.isEmpty()) {
                ((Tackable)list.get(0)).equipTack(SoundSource.BLOCKS, stack, null);
                stack.m_41774_(1);
                this.m_123573_(true);
                return stack;
            }
            return super.m_7498_(source, stack);
        }
    };
    static OptionalDispenseItemBehavior BREAST_COLLAR_BEHAVIOR = new OptionalDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            List list = source.m_7727_().m_6443_(LivingEntity.class, new AABB(blockpos), p_123527_ -> {
                if (!(p_123527_ instanceof Tackable)) {
                    return false;
                }
                Tackable saddleable = (Tackable)p_123527_;
                return !saddleable.hasBreastCollar() && !saddleable.isWearingPastureBlanket() && saddleable.hasHalter() && saddleable.canReceiveTack(null);
            });
            if (!list.isEmpty()) {
                ((Tackable)list.get(0)).equipTack(SoundSource.BLOCKS, stack, null);
                stack.m_41774_(1);
                this.m_123573_(true);
                return stack;
            }
            return super.m_7498_(source, stack);
        }
    };

    public static void init() {
        for (DyeColor color : DyeColor.values()) {
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.WESTERN_BLANKETS.get(color.m_41060_()).get()), (DispenseItemBehavior)BLANKET_BEHAVIOR);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.WESTERN_BRIDLES.get(color.m_41060_()).get()), (DispenseItemBehavior)HALTER_BEHAVIOR);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.WESTERN_SADDLES.get(color.m_41060_()).get()), (DispenseItemBehavior)SADDLE_BEHAVIOR);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.WESTERN_GIRTH_STRAPS.get(color.m_41060_()).get()), (DispenseItemBehavior)GIRTH_STRAP_BEHAVIOR);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.WESTERN_LEG_WRAPS.get(color.m_41060_()).get()), (DispenseItemBehavior)LEG_WRAPS_BEHAVIOR);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.WESTERN_BREAST_COLLARS.get(color.m_41060_()).get()), (DispenseItemBehavior)BREAST_COLLAR_BEHAVIOR);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.HALTERS.get(color.m_41060_()).get()), (DispenseItemBehavior)HALTER_BEHAVIOR);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ENGLISH_LEG_WRAPS.get(color.m_41060_()).get()), (DispenseItemBehavior)LEG_WRAPS_BEHAVIOR);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ENGLISH_BLANKETS.get(color.m_41060_()).get()), (DispenseItemBehavior)BLANKET_BEHAVIOR);
        }
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ENGLISH_SADDLE_BLACK.get()), (DispenseItemBehavior)SADDLE_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ENGLISH_SADDLE_BROWN.get()), (DispenseItemBehavior)SADDLE_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ENGLISH_BREAST_COLLAR_BLACK.get()), (DispenseItemBehavior)BREAST_COLLAR_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ENGLISH_BREAST_COLLAR_BROWN.get()), (DispenseItemBehavior)BREAST_COLLAR_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ENGLISH_BRIDLE_BLACK.get()), (DispenseItemBehavior)HALTER_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ENGLISH_BRIDLE_BROWN.get()), (DispenseItemBehavior)HALTER_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ENGLISH_GIRTH_STRAP_BLACK.get()), (DispenseItemBehavior)GIRTH_STRAP_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ENGLISH_GIRTH_STRAP_BROWN.get()), (DispenseItemBehavior)GIRTH_STRAP_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ADVENTURE_SADDLE.get()), (DispenseItemBehavior)SADDLE_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ADVENTURE_SADDLE_SULTAN.get()), (DispenseItemBehavior)SADDLE_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ADVENTURE_SADDLE_ELVEN.get()), (DispenseItemBehavior)SADDLE_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ADVENTURE_SADDLE_USA.get()), (DispenseItemBehavior)SADDLE_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ADVENTURE_SADDLE_WITHERED.get()), (DispenseItemBehavior)SADDLE_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ADVENTURE_BLANKET.get()), (DispenseItemBehavior)BLANKET_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ADVENTURE_BREAST_COLLAR.get()), (DispenseItemBehavior)BREAST_COLLAR_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ADVENTURE_BRIDLE.get()), (DispenseItemBehavior)HALTER_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ADVENTURE_GIRTH_STRAP.get()), (DispenseItemBehavior)GIRTH_STRAP_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemSetup.ADVENTURE_LEG_WRAPS.get()), (DispenseItemBehavior)LEG_WRAPS_BEHAVIOR);
    }
}

