/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game.flight;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.FlightBehavior;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundSetFlightPacket {
    private final boolean startFlight;

    public ServerBoundSetFlightPacket(boolean startFlight) {
        this.startFlight = startFlight;
    }

    public static void encode(ServerBoundSetFlightPacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.startFlight);
    }

    public static ServerBoundSetFlightPacket decode(FriendlyByteBuf buf) {
        return new ServerBoundSetFlightPacket(buf.readBoolean());
    }

    public static class Handler {
        public static void handle(ServerBoundSetFlightPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                Entity patt1227$temp = player.m_275832_();
                if (!(patt1227$temp instanceof SWEMHorseEntityBase)) {
                    player.m_5661_((Component)Component.m_237113_((String)"You must be on a SWEM horse to toggle flight"), true);
                    return;
                }
                SWEMHorseEntityBase horse = (SWEMHorseEntityBase)patt1227$temp;
                FlightBehavior flight = horse.getBehavior(FlightBehavior.class);
                if (packet.startFlight) {
                    horse.startFlying();
                } else {
                    flight.stopFlight(false);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

