/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game;

import com.alaharranhonor.swem.forge.entities.horse.progression.HorseSkill;
import com.alaharranhonor.swem.forge.network.protocol.Packet;
import com.alaharranhonor.swem.forge.network.protocol.ServerPacketHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundHorseXPPacket
extends Packet {
    private final UUID entityUUID;
    private final float xpToAdd;
    private final HorseSkill skillToIncrease;

    public ServerboundHorseXPPacket(UUID entityUUID, float xpToAdd, HorseSkill skillToIncrease) {
        this.entityUUID = entityUUID;
        this.xpToAdd = xpToAdd;
        this.skillToIncrease = skillToIncrease;
    }

    public ServerboundHorseXPPacket(FriendlyByteBuf reader) {
        super(reader);
        this.entityUUID = reader.m_130259_();
        this.xpToAdd = reader.readFloat();
        this.skillToIncrease = (HorseSkill)reader.m_130066_(HorseSkill.class);
    }

    @Override
    public void encode(FriendlyByteBuf writer) {
        writer.m_130077_(this.entityUUID);
        writer.writeFloat(this.xpToAdd);
        writer.m_130068_((Enum)this.skillToIncrease);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ServerPacketHandler.handleHorseXP(this, (NetworkEvent.Context)ctx.get()));
        ctx.get().setPacketHandled(true);
    }

    public UUID getEntityUUID() {
        return this.entityUUID;
    }

    public float getXpToAdd() {
        return this.xpToAdd;
    }

    public HorseSkill getSkillToIncrease() {
        return this.skillToIncrease;
    }
}

