/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.network.protocol.SWEMPackets;
import com.alaharranhonor.swem.forge.network.protocol.game.ClientboundHorseJumpPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ServerboundHorseJumpPacket {
    private int entityID;
    private float jumpHeight;
    private final boolean failed;

    public ServerboundHorseJumpPacket(int entityID, float jumpHeight) {
        this.entityID = entityID;
        this.jumpHeight = jumpHeight;
        this.failed = false;
    }

    public ServerboundHorseJumpPacket(boolean failed) {
        this.failed = failed;
    }

    public static ServerboundHorseJumpPacket decode(ByteBuf buf) {
        try {
            int entityID = buf.readInt();
            float jumpHeight = buf.readFloat();
            return new ServerboundHorseJumpPacket(entityID, jumpHeight);
        }
        catch (IndexOutOfBoundsException e) {
            ModRef.LOGGER.error("CHorseJumpPacket: Unexpected end of packet.\nMessage: " + ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.writerIndex()), (Throwable)e);
            return new ServerboundHorseJumpPacket(true);
        }
    }

    public static void encode(ServerboundHorseJumpPacket msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityID);
        buffer.writeFloat(msg.jumpHeight);
    }

    public static void handle(ServerboundHorseJumpPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_().m_6815_(msg.entityID);
            if (!(entity instanceof SWEMHorseEntityBase)) {
                return;
            }
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            if (msg.jumpHeight > 0.0f) {
                horse.m_30655_(true);
                horse.awardIntegerStat(SWEMHorseEntityBase.JUMP_STAT, 1);
                if (msg.jumpHeight > 5.0f) {
                    horse.m_20088_().m_135381_(SWEMHorseEntityBase.JUMP_ANIM_TIMER, (Object)36);
                } else if (msg.jumpHeight > 4.0f) {
                    horse.m_20088_().m_135381_(SWEMHorseEntityBase.JUMP_ANIM_TIMER, (Object)28);
                } else if (msg.jumpHeight > 3.0f) {
                    horse.m_20088_().m_135381_(SWEMHorseEntityBase.JUMP_ANIM_TIMER, (Object)24);
                } else if (msg.jumpHeight > 2.0f) {
                    horse.m_20088_().m_135381_(SWEMHorseEntityBase.JUMP_ANIM_TIMER, (Object)30);
                } else {
                    horse.m_20088_().m_135381_(SWEMHorseEntityBase.JUMP_ANIM_TIMER, (Object)21);
                }
            }
            horse.m_6210_();
            SWEMPackets.sendToPlayers(PacketDistributor.TRACKING_ENTITY.with(() -> horse), new ClientboundHorseJumpPacket(msg.entityID, msg.jumpHeight));
        });
        ctx.get().setPacketHandled(true);
    }
}

