/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.ActionBehavior;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundHorseActionPacket {
    private UUID entityID;
    private ActionBehavior.Action action;

    public ServerboundHorseActionPacket(UUID entityID, ActionBehavior.Action action) {
        this.entityID = entityID;
        this.action = action;
    }

    public static void encode(ServerboundHorseActionPacket msg, FriendlyByteBuf buffer) {
        buffer.m_130077_(msg.entityID);
        buffer.writeInt(msg.action.id);
    }

    public static ServerboundHorseActionPacket decode(FriendlyByteBuf buf) {
        UUID entityID = buf.m_130259_();
        int actionId = buf.readInt();
        return new ServerboundHorseActionPacket(entityID, ActionBehavior.Action.getActionById(actionId));
    }

    public static void handle(ServerboundHorseActionPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Entity entity = player.m_284548_().m_8791_(msg.entityID);
            if (!(entity instanceof SWEMHorseEntityBase)) {
                return;
            }
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            horse.getBehavior(ActionBehavior.class).startAction(msg.action);
        });
        ctx.get().setPacketHandled(true);
    }
}

