/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class SCameraLockPacket {
    private int horseId;
    private float yRot;
    private float xRot;
    private final boolean failed;

    public SCameraLockPacket(int horseId, float yRot, float xRot) {
        this.horseId = horseId;
        this.yRot = yRot;
        this.xRot = xRot;
        this.failed = false;
    }

    public SCameraLockPacket(boolean failed) {
        this.failed = failed;
    }

    public static SCameraLockPacket decode(ByteBuf buf) {
        try {
            int horseUUID = buf.readInt();
            float yRot = buf.readFloat();
            float xRot = buf.readFloat();
            return new SCameraLockPacket(horseUUID, yRot, xRot);
        }
        catch (IndexOutOfBoundsException e) {
            ModRef.LOGGER.error("SCameraLockPacket: Unexpected end of packet.\nMessage: " + ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.writerIndex()), (Throwable)e);
            return new SCameraLockPacket(true);
        }
    }

    public static void encode(SCameraLockPacket msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.horseId);
        buffer.writeFloat(msg.yRot);
        buffer.writeFloat(msg.xRot);
    }

    public static void handle(SCameraLockPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(msg.horseId);
            if (!(entity instanceof SWEMHorseEntityBase)) {
                return;
            }
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            horse.setLockedRotations(msg.xRot, msg.yRot);
        });
        ctx.get().setPacketHandled(true);
    }
}

