/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game;

import com.alaharranhonor.swem.forge.network.protocol.ClientPacketHandler;
import com.alaharranhonor.swem.forge.network.protocol.Packet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundHorseInventoryPacket
extends Packet {
    private final int entityId;
    private final byte slotIndex;
    private final ItemStack stack;

    public ClientboundHorseInventoryPacket(int entityId, byte slotIndex, ItemStack stack) {
        this.entityId = entityId;
        this.slotIndex = slotIndex;
        this.stack = stack;
    }

    public ClientboundHorseInventoryPacket(FriendlyByteBuf reader) {
        super(reader);
        this.entityId = reader.readInt();
        this.slotIndex = reader.readByte();
        this.stack = reader.m_130267_();
    }

    @Override
    public void encode(FriendlyByteBuf writer) {
        writer.writeInt(this.entityId);
        writer.writeByte((int)this.slotIndex);
        writer.m_130055_(this.stack);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleHorseInventoryUpdate(this)));
        ctx.get().setPacketHandled(true);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public byte getSlotIndex() {
        return this.slotIndex;
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

