/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.network.protocol.SWEMPackets;
import com.alaharranhonor.swem.forge.network.protocol.game.ServerboundHorseAnimationPacket;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundHorseAnimationPacket {
    private int entityID;
    private int action;

    public ClientboundHorseAnimationPacket(int entityID, int action) {
        this.entityID = entityID;
        this.action = action;
    }

    public static ClientboundHorseAnimationPacket decode(ByteBuf buf) {
        int entityID = buf.readInt();
        int action = buf.readInt();
        return new ClientboundHorseAnimationPacket(entityID, action);
    }

    public static void encode(ClientboundHorseAnimationPacket msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityID);
        buffer.writeInt(msg.action);
    }

    public static void handle(ClientboundHorseAnimationPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Entity entity = player.m_9236_().m_6815_(msg.entityID);
            if (!(entity instanceof SWEMHorseEntityBase)) {
                return;
            }
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            horse.setDisobedienceTimer(142);
            switch (msg.action) {
                case 3: {
                    horse.isWalkingBackwards = true;
                    break;
                }
                case 4: {
                    horse.isWalkingBackwards = false;
                    break;
                }
                case 9: {
                    SWEMPackets.sendToServer(new ServerboundHorseAnimationPacket(horse.m_19879_(), 5));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

