/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class CMountEntityPacket {
    private int targetId;
    private boolean failed;

    public CMountEntityPacket(int targetId) {
        this.targetId = targetId;
        this.failed = this.failed;
    }

    public CMountEntityPacket(Entity target) {
        this.targetId = target.m_19879_();
        this.failed = false;
    }

    public CMountEntityPacket(boolean failed) {
        this.failed = failed;
    }

    public static CMountEntityPacket decode(ByteBuf buf) {
        try {
            int targetId = buf.readInt();
            return new CMountEntityPacket(targetId);
        }
        catch (IndexOutOfBoundsException e) {
            ModRef.LOGGER.error("CMountEntityPacket: Unexpected end of packet.\nMessage: " + ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.writerIndex()), (Throwable)e);
            return new CMountEntityPacket(true);
        }
    }

    public static void encode(CMountEntityPacket msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.targetId);
    }

    private static boolean tryMounting(Entity rider, Entity mount) {
        if (!(rider instanceof LivingEntity)) {
            return false;
        }
        return rider.m_20329_(mount);
    }

    public static void handle(CMountEntityPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity mount;
            ServerPlayer clickingPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            Entity clickTarget = clickingPlayer.m_9236_().m_6815_(msg.targetId);
            if (clickTarget == null) {
                ModRef.LOGGER.warn("Could not find entity with id: " + msg.targetId + " requested by " + clickingPlayer.m_7755_().getString());
                return;
            }
            if (!clickTarget.m_6095_().m_20674_().m_21609_()) {
                return;
            }
            if (clickTarget instanceof Player) {
                return;
            }
            if (clickingPlayer.m_20159_() && (mount = clickingPlayer.m_20202_()) instanceof SWEMHorseEntityBase && !(clickTarget instanceof SWEMHorseEntityBase) && CMountEntityPacket.tryMounting(clickTarget, mount)) {
                return;
            }
            if (clickTarget instanceof SWEMHorseEntityBase) {
                SWEMHorseEntityBase horse = (SWEMHorseEntityBase)clickTarget;
                for (Entity passenger : clickTarget.m_20197_()) {
                    if (passenger instanceof Player && passenger == clickingPlayer) continue;
                    if (!(passenger instanceof Player)) {
                        passenger.m_8127_();
                        continue;
                    }
                    if (!horse.isOwner((Player)clickingPlayer)) continue;
                    passenger.m_8127_();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

