/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootModifierManager;

public abstract class FunctionLootModifier
extends LootModifier {
    public static final Codec<LootItemFunction[]> LOOT_FUNCTIONS_CODEC = Codec.PASSTHROUGH.flatXmap(d -> {
        try {
            LootItemFunction[] conditions = (LootItemFunction[])LootModifierManager.GSON_INSTANCE.fromJson(FunctionLootModifier.getJson(d), LootItemFunction[].class);
            return DataResult.success((Object)conditions);
        }
        catch (JsonSyntaxException e) {
            LootModifierManager.LOGGER.warn("Unable to decode loot functions", (Throwable)e);
            return DataResult.error(e::getMessage);
        }
    }, functions -> {
        try {
            JsonElement element = LootModifierManager.GSON_INSTANCE.toJsonTree(functions);
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)element));
        }
        catch (JsonSyntaxException e) {
            LootModifierManager.LOGGER.warn("Unable to encode loot functions", (Throwable)e);
            return DataResult.error(e::getMessage);
        }
    });
    private final LootItemFunction[] functions;

    static <U> JsonElement getJson(Dynamic<?> dynamic) {
        Dynamic<?> typed = dynamic;
        return typed.getValue() instanceof JsonElement ? (JsonElement)typed.getValue() : (JsonElement)typed.getOps().convertTo((DynamicOps)JsonOps.INSTANCE, typed.getValue());
    }

    protected static <T extends FunctionLootModifier> Products.P2<RecordCodecBuilder.Mu<T>, LootItemCondition[], LootItemFunction[]> functionsCodecStart(RecordCodecBuilder.Instance<T> instance) {
        return LootModifier.codecStart(instance).and((App)LOOT_FUNCTIONS_CODEC.fieldOf("functions").forGetter(FunctionLootModifier::getFunctions));
    }

    protected FunctionLootModifier(LootItemCondition[] conditionsIn, LootItemFunction[] functions) {
        super(conditionsIn);
        this.functions = functions;
    }

    protected ItemStack applyFunctions(ItemStack stack, LootContext ctx) {
        ItemStack modifiedStack = stack.m_41777_();
        for (LootItemFunction function : this.functions) {
            modifiedStack = (ItemStack)function.apply((Object)modifiedStack, (Object)ctx);
        }
        return modifiedStack;
    }

    public LootItemFunction[] getFunctions() {
        return this.functions;
    }
}

