/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.loot;

import com.alaharranhonor.swem.forge.loot.FunctionLootModifier;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ChestLootModifier
extends LootModifier {
    public static final Codec<ChestLootModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ResourceLocation.f_135803_.listOf().fieldOf("lootIds").forGetter(ChestLootModifier::getLootIds), (App)Codec.pair((Codec)ForgeRegistries.ITEMS.getCodec().listOf().fieldOf("items").codec(), (Codec)Codec.pair((Codec)FunctionLootModifier.LOOT_FUNCTIONS_CODEC.fieldOf("functions").codec(), (Codec)LOOT_CONDITIONS_CODEC.fieldOf("conditions").codec())).listOf().fieldOf("stacks").forGetter(ChestLootModifier::getItems))).apply((Applicative)inst, ChestLootModifier::new));
    private final List<ResourceLocation> lootIds;
    private final List<Pair<List<Item>, Pair<LootItemFunction[], LootItemCondition[]>>> items;

    protected ChestLootModifier(LootItemCondition[] conditionsIn, List<ResourceLocation> lootIds, List<Pair<List<Item>, Pair<LootItemFunction[], LootItemCondition[]>>> items) {
        super(conditionsIn);
        this.lootIds = lootIds;
        this.items = items;
    }

    public List<ResourceLocation> getLootIds() {
        return this.lootIds;
    }

    public List<Pair<List<Item>, Pair<LootItemFunction[], LootItemCondition[]>>> getItems() {
        return this.items;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!this.getLootIds().contains(context.getQueriedLootTableId())) {
            return generatedLoot;
        }
        for (Pair<List<Item>, Pair<LootItemFunction[], LootItemCondition[]>> pair : this.items) {
            block1: for (Item item : (List)pair.getFirst()) {
                ItemStack stack = new ItemStack((ItemLike)item);
                Pair funcConditions = (Pair)pair.getSecond();
                for (LootItemCondition lootItemCondition : (LootItemCondition[])funcConditions.getSecond()) {
                    if (!lootItemCondition.test((Object)context)) continue block1;
                }
                for (LootItemCondition lootItemCondition : (LootItemFunction[])funcConditions.getFirst()) {
                    stack = (ItemStack)lootItemCondition.apply((Object)stack, (Object)context);
                }
                generatedLoot.add((Object)stack);
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

