/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.items.tools;

import com.alaharranhonor.swem.forge.blocks.jumps.JumpControllerBlock;
import com.alaharranhonor.swem.forge.blocks.jumps.JumpLayer;
import com.alaharranhonor.swem.forge.blocks.jumps.StandardLayer;
import com.alaharranhonor.swem.forge.container.JumpContainer;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import com.alaharranhonor.swem.forge.tileentity.JumpBE;
import com.alaharranhonor.swem.forge.tileentity.JumpPasserBE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkHooks;

public class MeasurementTool
extends Item {
    public MeasurementTool(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.PASS;
        }
        BlockEntity te = context.m_43725_().m_7702_(context.m_8083_());
        if (te != null) {
            JumpPasserBE jumpPasser;
            if (te instanceof JumpPasserBE && (jumpPasser = (JumpPasserBE)te).getControllerPos() != null) {
                final JumpBE controller = (JumpBE)context.m_43725_().m_7702_(jumpPasser.getControllerPos());
                MenuProvider provider = new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237115_((String)"screen.swem.jump_builder");
                    }

                    @Nullable
                    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
                        return new JumpContainer(p_createMenu_1_, p_createMenu_2_, controller);
                    }
                };
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)context.m_43723_()), (MenuProvider)provider, buffer -> buffer.m_130064_(controller.m_58899_()));
            }
            if (te instanceof JumpBE) {
                final JumpBE jumpController = (JumpBE)te;
                if (jumpController.layerAmount == 0) {
                    return InteractionResult.PASS;
                }
                MenuProvider provider = new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237115_((String)"screen.swem.jump_builder");
                    }

                    @Nullable
                    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
                        return new JumpContainer(p_createMenu_1_, p_createMenu_2_, jumpController);
                    }
                };
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)context.m_43723_()), (MenuProvider)provider, buffer -> buffer.m_130064_(jumpController.m_58899_()));
            }
            return InteractionResult.CONSUME;
        }
        ItemStack stack = context.m_43722_();
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("pos1")) {
            int[] posCords = nbt.m_128465_("pos1");
            BlockPos firstPos = new BlockPos(posCords[0], posCords[1], posCords[2]);
            BlockPos pos = context.m_8083_();
            Direction initialDirection = Direction.m_122402_((String)nbt.m_128461_("direction"));
            if (initialDirection != context.m_8125_()) {
                nbt.m_128473_("pos1");
                nbt.m_128473_("direction");
                stack.m_41751_(nbt);
                context.m_43723_().m_5661_((Component)Component.m_237113_((String)"You are not facing the same direction as the first position"), true);
                return InteractionResult.FAIL;
            }
            int direction = this.isValidPos(firstPos, pos, initialDirection);
            if (direction == -1) {
                context.m_43723_().m_5661_((Component)Component.m_237113_((String)"The jump base is on the ground! Make sure you make your jump on the same Y level!"), true);
            } else if (direction == -2) {
                context.m_43723_().m_5661_((Component)Component.m_237113_((String)"The gap is too wide or too narrow! Must be block, 5 spaces, then another block."), true);
            } else if (direction == -3) {
                context.m_43723_().m_5661_((Component)Component.m_237113_((String)"The block gap must be left/right of the way you are facing, not forward/backward."), true);
            }
            if (direction <= 0) {
                nbt.m_128473_("pos1");
                nbt.m_128473_("direction");
                stack.m_41751_(nbt);
                return InteractionResult.CONSUME;
            }
            ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
            BlockPos.m_121940_((BlockPos)firstPos, (BlockPos)pos).forEach(ps -> {
                BlockPos pos1 = ps.m_7949_();
                blockPositions.add(pos1);
            });
            int layerAmount = blockPositions.size() / 7;
            nbt.m_128473_("pos1");
            nbt.m_128473_("direction");
            int lowestYValue = Math.min(firstPos.m_123342_(), pos.m_123342_());
            Map<Integer, ArrayList<BlockPos>> layers = this.rearrangeLayers(lowestYValue, blockPositions);
            Direction facing = context.m_8125_().m_122434_() == Direction.Axis.Z ? Direction.SOUTH : Direction.WEST;
            context.m_43725_().m_7731_(layers.get(1).get(0).m_5484_(Direction.UP, 5), (BlockState)((Block)BlockSetup.JUMP_CONTROLLER.get()).m_49966_().m_61124_((Property)JumpControllerBlock.f_54117_, (Comparable)facing), 3);
            final JumpBE jumpController = (JumpBE)context.m_43725_().m_7702_(layers.get(1).get(0).m_5484_(Direction.UP, 5));
            jumpController.setLayerAmount(layerAmount);
            jumpController.assignJumpBlocks(layers);
            jumpController.initStandards(StandardLayer.SCHOOLING);
            for (int i = 1; i <= layerAmount; ++i) {
                jumpController.placeLayer(i, JumpLayer.NONE);
            }
            MenuProvider provider = new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237115_((String)"screen.swem.jump_builder");
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
                    return new JumpContainer(p_createMenu_1_, p_createMenu_2_, jumpController);
                }
            };
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)context.m_43723_()), (MenuProvider)provider, buffer -> buffer.m_130064_(jumpController.m_58899_()));
            stack.m_41751_(new CompoundTag());
            return InteractionResult.CONSUME;
        }
        BlockPos pos = context.m_8083_();
        nbt.m_128385_("pos1", new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        nbt.m_128359_("direction", context.m_8125_().m_7912_());
        stack.m_41751_(nbt);
        return InteractionResult.CONSUME;
    }

    private Map<Integer, ArrayList<BlockPos>> rearrangeLayers(int lowestYValue, ArrayList<BlockPos> positions) {
        HashMap<Integer, ArrayList<BlockPos>> layers = new HashMap<Integer, ArrayList<BlockPos>>();
        for (int i = 1; i <= positions.size(); ++i) {
            BlockPos pos = positions.get(i - 1);
            int layerNumber = pos.m_123342_() - lowestYValue + 1;
            ArrayList<BlockPos> layer = layers.getOrDefault(layerNumber, new ArrayList());
            layer.add(pos);
            layers.put(layerNumber, layer);
        }
        return layers;
    }

    private int isValidPos(BlockPos first, BlockPos second, Direction initialDirection) {
        if (first.m_123342_() != second.m_123342_()) {
            return -1;
        }
        if (initialDirection.m_122434_() == Direction.Axis.Z ? first.m_123343_() != second.m_123343_() : first.m_123341_() != second.m_123341_()) {
            return -3;
        }
        if (initialDirection.m_122434_() == Direction.Axis.X) {
            if (first.m_123343_() - second.m_123343_() == -6) {
                return 1;
            }
            if (first.m_123343_() - second.m_123343_() == 6) {
                return 2;
            }
            return -2;
        }
        if (initialDirection.m_122434_() == Direction.Axis.Z) {
            if (first.m_123341_() - second.m_123341_() == -6) {
                return 3;
            }
            if (first.m_123341_() - second.m_123341_() == 6) {
                return 4;
            }
            return -2;
        }
        return -3;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        stack.m_41751_(new CompoundTag());
    }
}

