/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.items.tools;

import com.alaharranhonor.swem.forge.registry.ItemSetup;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

public class AmethystShield
extends ShieldItem {
    private static final UUID BROKEN_ATTRIBUTE_MODIFIER = UUID.fromString("339c12f0-caab-4cbc-8335-a134fa12fc2c");

    public AmethystShield(Item.Properties builder) {
        super(builder);
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.m_41773_() == stack.m_41776_() - 1;
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        return AmethystShield.isBroken(pStack) ? 0.0f : super.m_8102_(pStack, pState);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> tooltips, TooltipFlag pIsAdvanced) {
        if (AmethystShield.isBroken(pStack)) {
            tooltips.add((Component)Component.m_237115_((String)"tool.broken").m_130940_(ChatFormatting.GRAY));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND && AmethystShield.isBroken(stack)) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, stack));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(BROKEN_ATTRIBUTE_MODIFIER, "broken", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (AmethystShield.isBroken(itemstack)) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return super.m_7203_(pLevel, pPlayer, pHand);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pItemSlot, boolean pIsSelected) {
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (pIsSelected && !AmethystShield.isBroken(pStack) && player.f_20930_ < pLevel.m_46467_() - 100L && pLevel.m_46467_() % 200L == 0L) {
                player.m_5634_(1.0f);
            }
        }
        super.m_6883_(pStack, pLevel, pEntity, pItemSlot, pIsSelected);
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return ItemSetup.CANTAZARITE.get() == pRepair.m_41720_();
    }

    @Mod.EventBusSubscriber(modid="swem", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class OnInventoryChangeListener {
        @SubscribeEvent
        public static void onInventoryChange(LivingEquipmentChangeEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            if (event.getTo().m_41720_() instanceof AmethystShield) {
                AttributeModifier modifier;
                ItemStack stack = event.getTo();
                CompoundTag nbt = stack.m_41784_();
                if (nbt.m_128441_("modifier")) {
                    CompoundTag mod = nbt.m_128469_("modifier");
                    modifier = new AttributeModifier(mod.m_128342_("uuid"), mod.m_128461_("name"), mod.m_128459_("value"), AttributeModifier.Operation.m_22236_((int)mod.m_128451_("operation")));
                } else {
                    modifier = new AttributeModifier("amethyst_shield", 20.0, AttributeModifier.Operation.ADDITION);
                    CompoundTag mod = new CompoundTag();
                    mod.m_128362_("uuid", modifier.m_22209_());
                    mod.m_128359_("name", modifier.m_22214_());
                    mod.m_128347_("value", modifier.m_22218_());
                    mod.m_128405_("operation", modifier.m_22217_().m_22235_());
                    nbt.m_128365_("modifier", (Tag)mod);
                    stack.m_41751_(nbt);
                }
                if (!player.m_21051_(Attributes.f_22276_).m_22109_(modifier)) {
                    player.m_21051_(Attributes.f_22276_).m_22118_(modifier);
                }
            }
            if (event.getFrom().m_41720_() instanceof AmethystShield) {
                CompoundTag nbt = event.getFrom().m_41783_();
                player.m_21051_(Attributes.f_22276_).m_22120_(nbt.m_128469_("modifier").m_128342_("uuid"));
                if (player.m_21223_() > player.m_21233_()) {
                    player.m_21153_(player.m_21233_());
                }
            }
        }
    }
}

