/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import org.jetbrains.annotations.Nullable;

public class AmethystScythe
extends HoeItem {
    private static final UUID BROKEN_ATTRIBUTE_MODIFIER = UUID.fromString("339c12f0-caab-4cbc-8335-a134fa12fc2c");
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public AmethystScythe(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        super(tier, attackDamageIn, attackSpeedIn, builderIn);
        this.attackDamage = (float)attackDamageIn + tier.m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.m_41773_() == stack.m_41776_() - 1;
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        return AmethystScythe.isBroken(pStack) ? 0.0f : super.m_8102_(pStack, pState);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND && AmethystScythe.isBroken(stack)) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, stack));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(BROKEN_ATTRIBUTE_MODIFIER, "broken", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> tooltips, TooltipFlag pIsAdvanced) {
        if (AmethystScythe.isBroken(pStack)) {
            tooltips.add((Component)Component.m_237115_((String)"tool.broken").m_130940_(ChatFormatting.GRAY));
        }
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        if (AmethystScythe.isBroken(pContext.m_43722_())) {
            return InteractionResult.FAIL;
        }
        return super.m_6225_(pContext);
    }

    public float m_41008_() {
        return this.attackDamage;
    }

    public boolean hitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!(attacker instanceof Player)) {
            return false;
        }
        Player player = (Player)attacker;
        float f = (float)player.m_21133_(Attributes.f_22281_);
        float f1 = target instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)target.m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)MobType.f_21640_);
        float f2 = player.m_36403_(0.5f);
        f *= 0.2f + f2 * f2 * 0.8f;
        f1 *= f2;
        boolean flag = f2 > 0.9f;
        boolean flag2 = flag && player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_() && target instanceof LivingEntity;
        flag2 = flag2 && !player.m_20142_();
        CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)player, (Entity)target, (boolean)flag2, (float)(flag2 ? 1.5f : 1.0f));
        boolean bl = flag2 = hitResult != null;
        if (flag2) {
            f *= hitResult.getDamageModifier();
        }
        float f3 = 1.0f + 0.6666666f * f;
        for (LivingEntity livingentity : player.m_9236_().m_45976_(LivingEntity.class, target.m_20191_().m_82377_(1.0, 0.25, 1.0))) {
            if (livingentity == player || livingentity == target || player.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(player.m_20280_((Entity)livingentity) < 9.0)) continue;
            livingentity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
            livingentity.m_6469_(livingentity.m_269291_().m_269075_(player), f3);
        }
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
        player.m_36346_();
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean onBlockDestroyed(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.f_46443_ && state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            stack.m_41622_(1, entityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(equipmentSlot);
    }
}

