/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.items;

import com.alaharranhonor.swem.forge.data.HorseDataElement;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.eventhandlers.CommonEventHandler;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TrackerItem
extends Item {
    public TrackerItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (target instanceof SWEMHorseEntityBase) {
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)target;
            if (horse.m_6162_() || !horse.m_30614_()) {
                return InteractionResult.FAIL;
            }
            if (!horse.m_21805_().equals(playerIn.m_20148_())) {
                playerIn.m_5661_((Component)Component.m_237113_((String)"You can't track horses, that aren't yours."), true);
                return InteractionResult.FAIL;
            }
            if (playerIn.m_6144_()) {
                CompoundTag tracked = playerIn.getPersistentData().m_128469_("tracked");
                CompoundTag trackedNew = new CompoundTag();
                boolean removed = false;
                for (int i = 0; i < tracked.m_128440_(); ++i) {
                    if (tracked.m_128342_(String.valueOf(i)).equals(horse.m_20148_())) {
                        playerIn.m_5661_((Component)Component.m_237113_((String)"Horse is no longer being tracked"), true);
                        removed = true;
                        horse.setTracked(false);
                        continue;
                    }
                    trackedNew.m_128362_(String.valueOf(removed ? i - 1 : i), tracked.m_128342_(String.valueOf(i)));
                }
                playerIn.getPersistentData().m_128365_("tracked", (Tag)trackedNew);
            } else {
                CompoundTag tracked = playerIn.getPersistentData().m_128469_("tracked");
                for (int i = 0; i < tracked.m_128440_(); ++i) {
                    if (!tracked.m_128342_(String.valueOf(i)).equals(horse.m_20148_())) continue;
                    playerIn.m_5661_((Component)Component.m_237113_((String)"Horse is already being tracked."), true);
                    return InteractionResult.FAIL;
                }
                tracked.m_128362_(Integer.toString(tracked.m_128440_()), horse.m_20148_());
                horse.setTracked(true);
                playerIn.m_5661_((Component)Component.m_237113_((String)"Horse is now being tracked"), true);
                playerIn.getPersistentData().m_128365_("tracked", (Tag)tracked);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!worldIn.f_46443_) {
            CompoundTag tracked = playerIn.getPersistentData().m_128469_("tracked");
            StringBuilder builder = new StringBuilder();
            int horsesNotFound = 0;
            for (int i = 0; i < tracked.m_128440_(); ++i) {
                UUID uuid = tracked.m_128342_(Integer.toString(i));
                HorseDataElement data = CommonEventHandler.getHorseDataManager().getHorseData(uuid);
                if (data != null) {
                    builder.append("Name: ").append(data.getName()).append(" x: ").append(data.getPosition().m_7096_()).append(" - y: ").append(data.getPosition().m_7098_()).append(" - z: ").append(data.getPosition().m_7094_()).append("\n");
                    continue;
                }
                ++horsesNotFound;
            }
            if (horsesNotFound > 0) {
                builder.append(horsesNotFound).append(" horse").append(horsesNotFound > 1 ? "s" : "").append(" was not found.");
            }
            playerIn.m_213846_((Component)Component.m_237113_((String)builder.toString()));
            return InteractionResultHolder.m_19096_((Object)playerIn.m_21120_(handIn));
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }
}

