/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.needs;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class ThirstNeed {
    private final SWEMHorseEntityBase horse;
    public ThirstState state = ThirstState.SATISIFIED;
    public int drinks;
    public int missedDrinks;

    public ThirstNeed(SWEMHorseEntityBase horse) {
        this.horse = horse;
        this.setState(ThirstState.SATISIFIED);
    }

    public void morningHungyTime() {
        this.drinks = 0;
        if (this.horse.m_30614_()) {
            this.horse.emitMehParticles((ServerLevel)this.horse.m_9236_(), 10);
        }
    }

    public void nightHungyTime() {
        AttributeInstance maxHealth;
        if (!this.horse.m_30614_()) {
            return;
        }
        if (this.drinks == 0) {
            ++this.missedDrinks;
            if (this.missedDrinks > 21) {
                this.missedDrinks = 21;
            }
        } else if (this.missedDrinks > 0) {
            this.missedDrinks -= 3;
            if (this.missedDrinks < 0) {
                this.missedDrinks = 0;
            }
        }
        if (this.state == ThirstState.EXICCOSIS) {
            AttributeInstance maxHealth2 = this.horse.m_21051_(Attributes.f_22276_);
            if (maxHealth2.m_22115_() > 6.0) {
                maxHealth2.m_22100_(maxHealth2.m_22115_() - 1.0);
            }
        } else if ((this.state == ThirstState.SATISIFIED || this.state == ThirstState.QUENCHED) && (maxHealth = this.horse.m_21051_(Attributes.f_22276_)).m_22115_() <= this.horse.getAlteredMaxHealth()) {
            maxHealth.m_22100_(maxHealth.m_22115_() + 1.0);
        }
        this.updateThirstState();
        this.horse.emitMehParticles((ServerLevel)this.horse.m_9236_(), 10);
    }

    public void updateThirstState() {
        this.setState(ThirstState.fromDrinks(this.missedDrinks, this.drinks));
    }

    public boolean canDrink() {
        return this.drinks < 2;
    }

    public void drink() {
        ++this.drinks;
    }

    public ThirstState getState() {
        return ThirstState.values()[(Integer)this.horse.m_20088_().m_135370_(SWEMHorseEntityBase.THIRST_STATE)];
    }

    public void setState(ThirstState state) {
        this.state = state;
        this.horse.m_20088_().m_135381_(SWEMHorseEntityBase.THIRST_STATE, (Object)state.ordinal());
        this.state.applyDebuff(this.horse);
    }

    public CompoundTag write(CompoundTag nbt) {
        if (this.state == null) {
            return nbt;
        }
        nbt.m_128359_("State", this.state.id);
        nbt.m_128405_("MissedDrinks", this.missedDrinks);
        nbt.m_128405_("Drinks", this.drinks);
        return nbt;
    }

    public void read(CompoundTag nbt) {
        this.missedDrinks = nbt.m_128451_("MissedDrinks");
        this.drinks = nbt.m_128451_("Drinks");
        if (nbt.m_128441_("State")) {
            this.setState(ThirstState.fromId(nbt.m_128461_("State")));
        } else {
            this.updateThirstState();
        }
    }

    public void setFromState(ThirstState state) {
        this.missedDrinks = state.missedDrinks;
        this.setState(state);
    }

    public boolean isInExsiccosis() {
        return this.state == ThirstState.EXICCOSIS;
    }

    public static enum ThirstState {
        EXICCOSIS("exiccosis", 7, SWEMHorseEntityBase.Gait.WALK, 0.3f, 0.3f),
        DEHYDRATED("dehydrated", 3, SWEMHorseEntityBase.Gait.CANTER, 0.2f, 0.2f),
        THIRSTY("thirsty", 1, SWEMHorseEntityBase.Gait.GALLOP, 0.1f, 0.1f),
        SATISIFIED("satisfied", 0, SWEMHorseEntityBase.Gait.GALLOP, 0.0f, 0.0f),
        QUENCHED("quenched", 0, SWEMHorseEntityBase.Gait.GALLOP, 0.0f, -0.1f);

        public static final UUID ATTRIBUTE_ID;
        public final String id;
        private final int missedDrinks;
        private final SWEMHorseEntityBase.Gait maxGait;
        public final float jumpDebuff;
        public final float obedienceDebuff;

        private ThirstState(String id, int missedDrinks, SWEMHorseEntityBase.Gait maxGait, float jumpDebuff, float obedienceDebuff) {
            this.id = id;
            this.missedDrinks = missedDrinks;
            this.maxGait = maxGait;
            this.jumpDebuff = jumpDebuff;
            this.obedienceDebuff = obedienceDebuff;
        }

        public boolean canBeAtSpeed(SWEMHorseEntityBase.Gait gait) {
            return gait.getGaitId() <= this.maxGait.getGaitId();
        }

        public void applyDebuff(SWEMHorseEntityBase horse) {
            AttributeInstance attr = horse.m_21051_(Attributes.f_22288_);
            attr.m_22120_(ATTRIBUTE_ID);
            if (this.jumpDebuff != 0.0f) {
                attr.m_22125_(new AttributeModifier(ATTRIBUTE_ID, this.id, (double)(-this.jumpDebuff), AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        }

        public void removeDebuff(SWEMHorseEntityBase horse) {
            AttributeInstance attr = horse.m_21051_(Attributes.f_22288_);
            attr.m_22120_(ATTRIBUTE_ID);
        }

        public static ThirstState fromId(String id) {
            for (ThirstState state : ThirstState.values()) {
                if (!state.id.equals(id)) continue;
                return state;
            }
            return SATISIFIED;
        }

        public static ThirstState fromDrinks(int missedDrinks, int drinks) {
            if (missedDrinks == 0 && drinks > 0) {
                if (drinks == 1) {
                    return SATISIFIED;
                }
                return QUENCHED;
            }
            for (ThirstState state : ThirstState.values()) {
                if (missedDrinks < state.missedDrinks) continue;
                return state;
            }
            return SATISIFIED;
        }

        public boolean reducesGallop() {
            return this.ordinal() < 3;
        }

        static {
            ATTRIBUTE_ID = UUID.fromString("6de8e35e-db55-4f65-b466-f86f8ca75cbc");
        }
    }
}

