/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.needs;

import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.GodBehavior;
import com.alaharranhonor.swem.forge.entities.horse.needs.HungerNeed;
import com.alaharranhonor.swem.forge.entities.horse.needs.ThirstNeed;
import java.util.Calendar;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class NeedManager {
    private final SWEMHorseEntityBase horse;
    private final ThirstNeed thirst;
    private final HungerNeed hunger;
    private boolean ranThisTick;

    public NeedManager(SWEMHorseEntityBase horse) {
        this.horse = horse;
        this.thirst = new ThirstNeed(horse);
        this.hunger = new HungerNeed(horse);
    }

    public ThirstNeed getThirst() {
        return this.thirst;
    }

    public HungerNeed getHunger() {
        return this.hunger;
    }

    public void read(CompoundTag nbt) {
        this.hunger.read(nbt.m_128469_("Hunger"));
        this.thirst.read(nbt.m_128469_("Thirst"));
        this.ranThisTick = nbt.m_128471_("Updated");
    }

    public CompoundTag write(CompoundTag nbt) {
        nbt.m_128365_("Hunger", (Tag)this.hunger.write(new CompoundTag()));
        nbt.m_128365_("Thirst", (Tag)this.thirst.write(new CompoundTag()));
        nbt.m_128379_("Updated", this.ranThisTick);
        return nbt;
    }

    public void tick() {
        if (this.horse.m_6162_()) {
            return;
        }
        if (this.horse.getBehavior(GodBehavior.class).isGod()) {
            return;
        }
        boolean morning = this.horse.m_9236_().m_46468_() % 24000L == 1000L;
        boolean night = this.horse.m_9236_().m_46468_() % 24000L == 14000L;
        boolean needsFood = (Boolean)ServerConfig.FOOD_NEED_ENABLED.get();
        boolean needsWater = (Boolean)ServerConfig.WATER_NEED_ENABLED.get();
        if (((Boolean)ServerConfig.SERVER_TIME.get()).booleanValue()) {
            Calendar calendar = Calendar.getInstance();
            int hour = calendar.get(11);
            morning = hour == ServerConfig.serverMorningHungyTime;
            boolean bl = night = hour == ServerConfig.serverEveningHungyTime;
        }
        if (morning || night) {
            if (this.ranThisTick) {
                return;
            }
            if (needsFood) {
                if (morning) {
                    this.hunger.morningHungyTime();
                }
                if (night) {
                    this.hunger.nightHungyTime();
                }
            }
            if (needsWater) {
                if (morning) {
                    this.thirst.morningHungyTime();
                }
                if (night) {
                    this.thirst.nightHungyTime();
                }
            }
            this.ranThisTick = true;
        } else {
            this.ranThisTick = false;
        }
    }

    public int getGallopTimerReduction() {
        int reduction = 0;
        if (this.hunger.getState().reducesGallop()) {
            reduction += 2;
        }
        if (this.thirst.getState().reducesGallop()) {
            reduction += 2;
        }
        return reduction;
    }

    public StringBuilder getNeedsText(String horseName, StringBuilder sb) {
        sb.append(horseName).append(" has gained ").append(this.hunger.points).append(" points today, has").append(this.hunger.ateGrain ? "" : " not").append(" eaten grain, has missed ").append(this.hunger.missedMeals).append(" meals and ").append(this.thirst.missedDrinks).append(" drinks.");
        return sb;
    }
}

