/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.coats;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.world.entity.animal.horse.Variant;

public enum HorseColor {
    BLACK(0, "black"),
    BROWN(1, "brown"),
    CHESTNUT(2, "chestnut"),
    CREAMY(3, "creamy"),
    DARK_BROWN(4, "dark_brown"),
    GRAY(5, "gray"),
    WHITE(6, "white");

    private final int id;
    private final String name;

    private HorseColor(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static HorseColor fromVanillaVariant(Variant vanillaVariant) {
        return switch (vanillaVariant) {
            default -> throw new IncompatibleClassChangeError();
            case Variant.WHITE -> WHITE;
            case Variant.CREAMY -> CREAMY;
            case Variant.CHESTNUT -> CHESTNUT;
            case Variant.BROWN -> BROWN;
            case Variant.BLACK -> BLACK;
            case Variant.GRAY -> GRAY;
            case Variant.DARK_BROWN -> DARK_BROWN;
        };
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public static HorseColor byId(int id) {
        for (HorseColor color : HorseColor.values()) {
            if (color.id != id) continue;
            return color;
        }
        return null;
    }

    public static HorseColor byName(String name) {
        for (HorseColor color : HorseColor.values()) {
            if (!Objects.equals(color.name, name)) continue;
            return color;
        }
        return null;
    }

    public static class Serializer
    implements JsonSerializer<HorseColor>,
    JsonDeserializer<HorseColor> {
        public HorseColor deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return HorseColor.byName(json.getAsString());
            }
            throw new JsonParseException("Invalid Horse Color " + json);
        }

        public JsonElement serialize(HorseColor src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.name);
        }
    }
}

