/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.behaviors.impl;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.entities.HorseAnimations;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.AbstractBehavior;
import com.alaharranhonor.swem.forge.util.TimeUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class SleepingBehavior
extends AbstractBehavior {
    public static final ResourceLocation ID = ModRef.res("sleeping");
    public static final EntityDataAccessor<Boolean> VISUAL_SLEEPING = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_SLEEPING = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    private boolean setToSleep;
    private int tiredTicks = 0;
    private int sleepCooldown = 0;

    public SleepingBehavior(SWEMHorseEntityBase horse) {
        super(ID, horse);
    }

    @Override
    public boolean shouldTick() {
        return !this.horse.m_9236_().m_5776_();
    }

    private void triggerAnimation(boolean isSleeping) {
        if (this.isVisuallySleeping() != isSleeping) {
            this.horse.triggerAnim("horse", isSleeping ? HorseAnimations.Keys.SLEEPING_IN : HorseAnimations.Keys.SLEEPING_OUT);
        }
    }

    @Override
    public void tick() {
        if (TimeUtil.isSleepTime(this.horse.m_9236_().m_8044_()) && !this.isActuallySleeping() && !this.horse.hasBridle() && this.horse.m_20197_().isEmpty()) {
            this.setForSleep();
            this.sleep();
        }
        if ((TimeUtil.isWakeUpTime(this.horse.m_9236_().m_8044_()) || this.horse.hasBridle()) && this.isActuallySleeping()) {
            this.wakeUp();
        }
    }

    public void setForSleep() {
        if (this.sleepCooldown > 0) {
            --this.sleepCooldown;
            return;
        }
        if (this.canSleep() && !this.setToSleep) {
            this.tiredTicks = 40 + this.horse.m_9236_().f_46441_.m_188503_(60);
            this.setToSleep = true;
            return;
        }
        if (this.tiredTicks > 0) {
            --this.tiredTicks;
        }
    }

    public boolean canSleep() {
        return !this.horse.m_20160_() && !this.horse.isInPanic() && !this.horse.isInFluidType();
    }

    public void sleep() {
        if (this.setToSleep && this.tiredTicks == 0 && this.sleepCooldown == 0) {
            this.setToSleep = false;
            this.horse.m_21573_().m_26573_();
            this.setSleeping(true);
        }
    }

    public void wakeUp() {
        this.setSleeping(false);
    }

    public void forceWakeUp(int cooldown) {
        this.wakeUp();
        this.sleepCooldown = cooldown;
        this.tiredTicks = 0;
        this.setToSleep = false;
        Level level = this.horse.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.horse.emitBadParticles(level2, 10);
        }
    }

    public void setSleeping(boolean sleeping) {
        this.triggerAnimation(sleeping);
        this.setData(IS_SLEEPING, sleeping);
    }

    public void setVisualSleeping(boolean sleeping) {
        this.triggerAnimation(sleeping);
        this.setData(VISUAL_SLEEPING, sleeping);
    }

    public boolean isActuallySleeping() {
        return this.getData(IS_SLEEPING);
    }

    public boolean isVisuallySleeping() {
        return this.getData(VISUAL_SLEEPING) != false || this.getData(IS_SLEEPING) != false;
    }

    @Override
    public void defineData(SynchedEntityData dataManager) {
        dataManager.m_135372_(IS_SLEEPING, (Object)false);
        dataManager.m_135372_(VISUAL_SLEEPING, (Object)false);
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag.m_128379_("SetToSleep", this.setToSleep);
        tag.m_128405_("TiredTicks", this.tiredTicks);
        tag.m_128405_("SleepCooldown", this.sleepCooldown);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        this.setToSleep = tag.m_128471_("SetToSleep");
        this.tiredTicks = tag.m_128451_("TiredTicks");
        this.sleepCooldown = tag.m_128451_("SleepCooldown");
    }
}

