/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.behaviors.impl;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.entities.HorseAnimations;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.AbstractBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class EatingBehavior
extends AbstractBehavior {
    public static final ResourceLocation ID = ModRef.res("eating");
    public static final EntityDataAccessor<Integer> EATING_TYPE = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> VISUAL_EATING_TYPE = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);

    public EatingBehavior(SWEMHorseEntityBase horse) {
        super(ID, horse);
    }

    @Override
    public void defineData(SynchedEntityData dataManager) {
        dataManager.m_135372_(EATING_TYPE, (Object)EatingType.NONE.ordinal());
        dataManager.m_135372_(VISUAL_EATING_TYPE, (Object)EatingType.NONE.ordinal());
    }

    private void triggerAnimation(EatingType type) {
        EatingType currentType = this.getVisualEatingType();
        if (currentType == EatingType.NONE && type != EatingType.NONE) {
            this.horse.triggerAnim("horse", type == EatingType.HALF ? HorseAnimations.Keys.HALF_LEAN_IN : HorseAnimations.Keys.LEAN_IN);
        } else if (currentType != EatingType.NONE && type == EatingType.NONE) {
            this.horse.triggerAnim("horse", currentType == EatingType.HALF ? HorseAnimations.Keys.HALF_LEAN_OUT : HorseAnimations.Keys.LEAN_OUT);
        }
    }

    public void startVisualEatingAt(Vec3 pos) {
        if (pos.f_82480_ > this.horse.m_20182_().f_82480_) {
            this.setVisualEatingType(EatingType.HALF);
        } else {
            this.setVisualEatingType(EatingType.FULL);
        }
    }

    public void startEatingAt(Vec3 pos) {
        if (pos.f_82480_ > this.horse.m_20182_().f_82480_) {
            this.setEatingType(EatingType.HALF);
        } else {
            this.setEatingType(EatingType.FULL);
        }
    }

    public void stopEating() {
        this.setEatingType(EatingType.NONE);
    }

    public void stopVisualEating() {
        this.setVisualEatingType(EatingType.NONE);
    }

    public boolean isActuallyEating() {
        return this.getData(EATING_TYPE).intValue() != EatingType.NONE.ordinal();
    }

    public boolean isVisuallyEating() {
        return this.getData(VISUAL_EATING_TYPE).intValue() != EatingType.NONE.ordinal() || this.isActuallyEating();
    }

    public EatingType getEatingType() {
        return EatingType.values()[this.getData(EATING_TYPE)];
    }

    public EatingType getVisualEatingType() {
        EatingType eatingType = EatingType.values()[this.getData(VISUAL_EATING_TYPE)];
        if (eatingType == EatingType.NONE) {
            eatingType = this.getEatingType();
        }
        return eatingType;
    }

    private void setVisualEatingType(EatingType type) {
        this.triggerAnimation(type);
        this.setData(VISUAL_EATING_TYPE, type.ordinal());
    }

    private void setEatingType(EatingType type) {
        this.triggerAnimation(type);
        this.setData(EATING_TYPE, type.ordinal());
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag.m_128405_("EatingType", this.getEatingType().ordinal());
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        this.setEatingType(EatingType.values()[tag.m_128451_("EatingType")]);
    }

    public static enum EatingType {
        NONE,
        HALF,
        FULL;

    }
}

