/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.behaviors.impl;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.entities.HorseAnimations;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.AbstractBehavior;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.core.animation.RawAnimation;

public class ActionBehavior
extends AbstractBehavior {
    public static final ResourceLocation ID = ModRef.res("action");
    private static final EntityDataAccessor<Integer> ACTION_ID = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ACTION_TIMER = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);

    public ActionBehavior(SWEMHorseEntityBase horse) {
        super(ID, horse);
    }

    @Override
    public void tick() {
        Action action = this.getActiveAction();
        int actionTick = this.getActionTick();
        if (actionTick <= 0) {
            this.stopAction();
            return;
        }
        if (--actionTick == action.executeTimer) {
            action.execute(this.horse);
        }
        this.setActionTick(actionTick);
    }

    @Override
    public boolean shouldTick() {
        return this.hasActiveAction();
    }

    public void startAction(Action action) {
        this.setAction(action);
        if (action.isStanding()) {
            this.horse.setDisobedienceTimer(142);
        }
        this.horse.triggerAnim("horse", action.animationKey);
    }

    public void stopAction() {
        this.horse.m_20088_().m_135381_(ACTION_ID, (Object)-1);
        this.horse.m_20088_().m_135381_(ACTION_TIMER, (Object)-1);
    }

    public boolean hasActiveAction() {
        return this.getActiveAction() != null;
    }

    @Nullable
    public Action getActiveAction() {
        return Action.getActionById((Integer)this.horse.m_20088_().m_135370_(ACTION_ID));
    }

    private void setAction(Action action) {
        this.horse.m_20088_().m_135381_(ACTION_ID, (Object)action.id);
        this.horse.m_20088_().m_135381_(ACTION_TIMER, (Object)action.timer);
    }

    public int getActionTick() {
        return (Integer)this.horse.m_20088_().m_135370_(ACTION_TIMER);
    }

    private void setActionTick(int tick) {
        this.horse.m_20088_().m_135381_(ACTION_TIMER, (Object)tick);
    }

    @Override
    public void defineData(SynchedEntityData dataManager) {
        dataManager.m_135372_(ACTION_ID, (Object)-1);
        dataManager.m_135372_(ACTION_TIMER, (Object)-1);
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
    }

    public static enum Action {
        REAR(0, 42, -1, horse -> {}, HorseAnimations.Keys.REAR, HorseAnimations.REAR),
        BUCK(1, 42, 20, SWEMHorseEntityBase::executeBuck, HorseAnimations.Keys.BUCK, HorseAnimations.BUCK),
        BITE(2, 35, 17, SWEMHorseEntityBase::executeBite, HorseAnimations.Keys.BITE, HorseAnimations.BITE),
        KICK(3, 14, 5, SWEMHorseEntityBase::executeKick, HorseAnimations.Keys.KICK, HorseAnimations.KICK),
        STOMP(4, 25, 5, SWEMHorseEntityBase::executeStomp, HorseAnimations.Keys.STOMP, HorseAnimations.STOMP);

        public final int id;
        private final int timer;
        private final int executeTimer;
        private final Consumer<SWEMHorseEntityBase> onExecute;
        public final String animationKey;
        public final RawAnimation animation;

        private Action(int id, int timer, int executeTimer, Consumer<SWEMHorseEntityBase> onExecute, String animationKey, RawAnimation animation) {
            this.id = id;
            this.timer = timer;
            this.executeTimer = executeTimer;
            this.onExecute = onExecute;
            this.animationKey = animationKey;
            this.animation = animation;
        }

        private void execute(SWEMHorseEntityBase horse) {
            this.onExecute.accept(horse);
        }

        public static Action getActionById(int id) {
            for (Action action : Action.values()) {
                if (action.id != id) continue;
                return action;
            }
            return null;
        }

        public boolean isStanding() {
            return this == REAR || this == BUCK;
        }
    }
}

