/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public enum HorseModelType {
    LEGACY("legacy"),
    DESTRIER("destrier"),
    HEAVY_DRAFT("heavy_draft"),
    WESTERN_SPORT("western_sport"),
    ENGLISH_SPORT("english_sport"),
    RIDING_PONY("riding_pony");

    private final String name;

    private HorseModelType(String name) {
        this.name = name;
    }

    public static HorseModelType fromName(String name) {
        for (HorseModelType type : HorseModelType.values()) {
            if (!type.name.equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public static class Serializer
    implements JsonSerializer<HorseModelType>,
    JsonDeserializer<HorseModelType> {
        public HorseModelType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                for (HorseModelType color : HorseModelType.values()) {
                    if (!color.name.equalsIgnoreCase(json.getAsString())) continue;
                    return color;
                }
            }
            throw new JsonParseException("Invalid Horse Model Type " + json);
        }

        public JsonElement serialize(HorseModelType src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.name);
        }
    }
}

