/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.ai;

import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.pathfinder.Path;

public class NaturalFallInLoveGoal
extends Goal {
    private static final TargetingConditions MARE_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_().m_26888_(e -> {
        SWEMHorseEntityBase horse;
        return e instanceof SWEMHorseEntityBase && (horse = (SWEMHorseEntityBase)e).getBreeding().isFemale() && horse.getBreeding().canFallInLove();
    });
    private int timer;
    private final SWEMHorseEntityBase horse;
    private SWEMHorseEntityBase partner;

    public NaturalFallInLoveGoal(SWEMHorseEntityBase horse) {
        this.horse = horse;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        SWEMHorseEntityBase partner;
        if (!(ServerConfig.enableNaturalBreeding && this.horse.getBreeding().isMale() && this.horse.getBreeding().canFallInLove() && this.timer++ >= 200)) {
            return false;
        }
        if ((double)this.horse.m_217043_().m_188501_() < 0.001 && (partner = this.getFreePartner()) != null) {
            this.partner = partner;
            this.timer = 0;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.horse.getBreeding().canFallInLove();
    }

    public void m_8056_() {
        this.horse.getBreeding().fallInLove(null);
        this.partner.getBreeding().fallInLove(null);
    }

    @Nullable
    private SWEMHorseEntityBase getFreePartner() {
        List mares = this.horse.m_9236_().m_45971_(SWEMHorseEntityBase.class, MARE_TARGETING, (LivingEntity)this.horse, this.horse.m_20191_().m_82400_(8.0));
        double distance = Double.MAX_VALUE;
        SWEMHorseEntityBase closestMare = null;
        for (SWEMHorseEntityBase mare : mares) {
            Path path;
            if (!(this.horse.m_20280_((Entity)mare) < distance) || (path = this.horse.m_21573_().m_6570_((Entity)mare, 1)) == null || !path.m_77403_()) continue;
            closestMare = mare;
            distance = this.horse.m_20280_((Entity)mare);
        }
        return closestMare;
    }
}

