/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.ai;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class MoveToWhistleGoal
extends Goal {
    private final SWEMHorseEntityBase horse;
    private final double speedModifier;
    private Player player;
    private SWEMHorseEntityBase.Gait targetGait;
    private boolean reachedTarget;

    public MoveToWhistleGoal(SWEMHorseEntityBase horse, double speedModifier) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.speedModifier = speedModifier;
        this.horse = horse;
    }

    public boolean m_8036_() {
        return this.isPlayerValid();
    }

    public boolean m_8045_() {
        return this.isPlayerValid() && !this.reachedTarget;
    }

    public void m_8056_() {
        this.moveToPlayer();
    }

    public void m_8041_() {
        this.reachedTarget = false;
        this.player = null;
        this.horse.setGait(SWEMHorseEntityBase.Gait.WALK);
    }

    public void m_8037_() {
        if (this.horse.m_20270_((Entity)this.player) > 4.0f) {
            this.reachedTarget = false;
            if (this.targetGait != this.horse.getGait()) {
                this.updateTargetSpeed();
            }
            if (this.shouldRecalculate()) {
                this.moveToPlayer();
            }
        } else {
            this.reachedTarget = true;
        }
    }

    private void updateTargetSpeed() {
        if (this.horse.getGait() != this.targetGait) {
            this.horse.setGait(this.targetGait);
        }
    }

    private boolean shouldRecalculate() {
        BlockPos targetPos = this.horse.m_21573_().m_26567_();
        if (targetPos == null) {
            return true;
        }
        Vec3 vecA = Vec3.m_82512_((Vec3i)targetPos).m_82546_(this.horse.m_20182_()).m_82541_();
        Vec3 vecB = this.player.m_20182_().m_82546_(this.horse.m_20182_()).m_82541_();
        return this.horse.m_21573_().m_26571_() || Math.abs(vecA.m_82526_(vecB)) < 0.9;
    }

    public void moveToPlayer() {
        this.horse.m_21573_().m_5624_((Entity)this.player, this.speedModifier);
        this.updateTargetSpeed();
    }

    public void setTarget(Player player, SWEMHorseEntityBase.Gait speed) {
        this.player = player;
        this.targetGait = speed;
    }

    private boolean isPlayerValid() {
        return this.player != null && this.player.m_6084_() && this.horse.isOwner(this.player);
    }
}

