/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.ai;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.EatingBehavior;
import com.alaharranhonor.swem.forge.entities.horse.needs.FeedItem;
import com.alaharranhonor.swem.forge.entities.horse.needs.Feeds;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;

public class HorseEatFoodGroundGoal
extends Goal {
    private final SWEMHorseEntityBase horse;
    private ItemEntity targetFood;
    private int eatTickTimer;

    public HorseEatFoodGroundGoal(SWEMHorseEntityBase horse) {
        this.horse = horse;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.isTargetValid() && this.horse.canEat();
    }

    public boolean m_8045_() {
        return this.isTargetValid() || this.eatTickTimer > 0;
    }

    public void setTarget(ItemEntity item) {
        this.targetFood = item;
    }

    public boolean hasTarget() {
        return this.isTargetValid();
    }

    public void m_8056_() {
        this.horse.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.horse.m_21573_().m_26573_();
        this.horse.getBehavior(EatingBehavior.class).stopEating();
        this.targetFood = null;
        this.eatTickTimer = 0;
    }

    public void m_8037_() {
        if (this.eatTickTimer > 0) {
            --this.eatTickTimer;
            if (this.targetFood != null) {
                if (!this.isTargetValid()) {
                    this.horse.getBehavior(EatingBehavior.class).stopEating();
                } else {
                    if (this.eatTickTimer == 20) {
                        this.eatTarget();
                        this.targetFood = null;
                        this.horse.getBehavior(EatingBehavior.class).stopEating();
                    }
                    return;
                }
            }
            return;
        }
        double distance = this.horse.m_20270_((Entity)this.targetFood);
        if (distance < 2.0) {
            this.horse.m_21573_().m_26573_();
            this.eatTickTimer = 63;
            this.horse.getBehavior(EatingBehavior.class).startEatingAt(this.targetFood.m_20182_());
            this.horse.m_7618_(EntityAnchorArgument.Anchor.EYES, this.targetFood.m_20182_());
            return;
        }
        Path path = this.horse.m_21573_().m_6570_((Entity)this.targetFood, 0);
        this.horse.m_21573_().m_26536_(path, 5.0);
    }

    private boolean isTargetValid() {
        if (this.targetFood == null || !this.targetFood.m_6084_()) {
            return false;
        }
        return Feeds.fromItem(this.targetFood.m_32055_()) != null;
    }

    private void eatTarget() {
        FeedItem feed = Feeds.fromItem(this.targetFood.m_32055_());
        if (this.horse.getNeeds().getHunger().feedWith(this.targetFood.m_32055_())) {
            ItemStack food;
            if (this.horse.isBreedingFood(this.targetFood.m_32055_())) {
                this.horse.handleEatingBreedingFood(null, this.targetFood.m_32055_());
            }
            if ((food = this.targetFood.m_32055_()).m_41720_().isDamageable(food)) {
                if (food.m_220157_(1, this.targetFood.m_9236_().m_213780_(), null)) {
                    food.m_41774_(1);
                }
            } else {
                food.m_41774_(1);
            }
            if (this.targetFood.m_32055_().m_41619_()) {
                this.targetFood.m_146870_();
            }
            if (feed.category() == FeedItem.Category.GRAINS) {
                this.horse.emitWootParticles((ServerLevel)this.horse.m_9236_(), 10);
            }
        }
    }
}

