/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.ai;

import com.alaharranhonor.swem.forge.blocks.PaddockFeederBlock;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.EatingBehavior;
import com.alaharranhonor.swem.forge.entities.horse.needs.FeedBlock;
import com.alaharranhonor.swem.forge.entities.horse.needs.FeedItem;
import com.alaharranhonor.swem.forge.entities.horse.needs.Feeds;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import com.alaharranhonor.swem.forge.tileentity.HorseFeeder;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class HorseEatFoodGoal
extends Goal {
    private final Set<BlockPos> blacklist;
    private final SWEMHorseEntityBase horse;
    private BlockPos targetFoodPos;
    private BlockState targetFood;
    private int eatTickTimer;
    private int stuckTimer;
    private BlockPos lastPos;

    public HorseEatFoodGoal(SWEMHorseEntityBase horse) {
        this.horse = horse;
        this.blacklist = new HashSet<BlockPos>();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.targetFoodPos != null && this.horse.canEat();
    }

    public boolean m_8045_() {
        if (this.targetFoodPos != null) {
            return this.isValidFeed(this.horse.m_9236_(), this.targetFoodPos);
        }
        return this.eatTickTimer > 0;
    }

    public void setup(BlockPos pos) {
        this.targetFoodPos = pos;
        this.targetFood = this.horse.m_9236_().m_8055_(pos);
    }

    public boolean isPosBlacklisted(BlockPos pos) {
        return this.blacklist.contains(pos);
    }

    public boolean hasTarget() {
        return this.targetFoodPos != null;
    }

    public void m_8056_() {
        this.horse.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.horse.m_21573_().m_26573_();
        this.horse.getBehavior(EatingBehavior.class).stopEating();
        this.targetFoodPos = null;
        this.targetFood = null;
        this.stuckTimer = 0;
        this.lastPos = null;
        this.eatTickTimer = 0;
    }

    public void m_8037_() {
        if (this.eatTickTimer > 0) {
            --this.eatTickTimer;
            if (this.targetFoodPos != null) {
                BlockState state = this.horse.m_9236_().m_8055_(this.targetFoodPos);
                BlockEntity be = this.horse.m_9236_().m_7702_(this.targetFoodPos);
                if (state.m_60713_((Block)BlockSetup.PADDOCK_FEEDER.get())) {
                    be = this.horse.m_9236_().m_7702_(PaddockFeederBlock.getMainPos(state, this.targetFoodPos));
                }
                if (!this.isValidFeed(this.horse.m_9236_(), this.targetFoodPos)) {
                    this.horse.getBehavior(EatingBehavior.class).stopEating();
                } else {
                    if (this.eatTickTimer == 20) {
                        FeedBlock feed = Feeds.fromBlock(state.m_60734_());
                        if (feed != null) {
                            this.eatBlock(state, feed);
                        } else if (be instanceof HorseFeeder) {
                            HorseFeeder feeder = (HorseFeeder)be;
                            this.eatFromFeeder(feeder);
                        }
                        this.targetFoodPos = null;
                        this.horse.getBehavior(EatingBehavior.class).stopEating();
                    }
                    return;
                }
            }
            return;
        }
        double distance = this.horse.m_20183_().m_123333_(new Vec3i(this.targetFoodPos.m_123341_(), this.targetFoodPos.m_123342_(), this.targetFoodPos.m_123343_()));
        if (distance <= 3.0) {
            this.horse.m_21573_().m_26573_();
            this.eatTickTimer = 63;
            this.horse.getBehavior(EatingBehavior.class).startEatingAt(Vec3.m_82512_((Vec3i)this.targetFoodPos));
            this.horse.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82512_((Vec3i)this.targetFoodPos));
            return;
        }
        this.horse.m_21573_().m_26519_((double)this.targetFoodPos.m_123341_(), (double)this.targetFoodPos.m_123342_(), (double)this.targetFoodPos.m_123343_(), 5.0);
        this.lastPos = this.horse.m_20183_();
        if (this.lastPos.equals((Object)this.horse.m_20183_())) {
            ++this.stuckTimer;
            if (this.stuckTimer > 80) {
                this.blacklist.add(this.targetFoodPos);
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        HorseEatFoodGoal.this.blacklist.remove(HorseEatFoodGoal.this.targetFoodPos);
                    }
                }, 300000L);
                this.m_8041_();
            }
        }
    }

    private boolean isValidFeed(Level level, BlockPos pos) {
        HorseFeeder feeder;
        BlockState state = level.m_8055_(pos);
        BlockEntity be = level.m_7702_(pos);
        return Feeds.fromBlock(state.m_60734_()) != null || be instanceof HorseFeeder && Feeds.fromItem((feeder = (HorseFeeder)be).peekStack(0)) != null || state.m_60713_((Block)BlockSetup.PADDOCK_FEEDER.get()) && (Integer)state.m_61143_((Property)PaddockFeederBlock.LEVEL) > 0;
    }

    private void eatFromFeeder(HorseFeeder feeder) {
        FeedItem feed = Feeds.fromItem(feeder.eat(0, this.horse));
        if (feed.category() == FeedItem.Category.GRAINS) {
            this.horse.emitWootParticles((ServerLevel)this.horse.m_9236_(), 10);
        }
    }

    private void eatBlock(BlockState state, FeedBlock feed) {
        this.horse.getNeeds().getHunger().feedWith(state);
        if (state.m_60713_(Blocks.f_50440_) && ForgeEventFactory.getMobGriefingEvent((Level)this.horse.m_9236_(), (Entity)this.horse)) {
            this.horse.m_9236_().m_46796_(2001, this.targetFoodPos, Block.m_49956_((BlockState)Blocks.f_50440_.m_49966_()));
        }
        this.horse.m_9236_().m_7731_(this.targetFoodPos, feed.getEaten(state), 3);
    }
}

