/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.datagen;

import com.alaharranhonor.swem.forge.datagen.client.BlockStateGen;
import com.alaharranhonor.swem.forge.datagen.client.ItemModelGen;
import com.alaharranhonor.swem.forge.datagen.client.LanguageGen;
import com.alaharranhonor.swem.forge.datagen.client.LanguageSheetData;
import com.alaharranhonor.swem.forge.datagen.server.AdvancementGen;
import com.alaharranhonor.swem.forge.datagen.server.BlockTagGen;
import com.alaharranhonor.swem.forge.datagen.server.EntityTypeTagGen;
import com.alaharranhonor.swem.forge.datagen.server.ItemTagGen;
import com.alaharranhonor.swem.forge.datagen.server.LootTableGen;
import com.alaharranhonor.swem.forge.datagen.server.RecipeGen;
import com.alaharranhonor.swem.forge.datagen.server.WorldGenGen;
import com.alaharranhonor.swem.forge.datagen.server.loot.BlockLoot;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="swem", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) throws IOException {
        DataGenerator data = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        PackOutput output = data.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        boolean includeServer = event.includeServer();
        boolean includeClient = event.includeClient();
        BlockTagGen blockTagGen = (BlockTagGen)data.addProvider(includeServer, (DataProvider)new BlockTagGen(output, lookupProvider, fileHelper));
        data.addProvider(includeServer, (DataProvider)new ItemTagGen(output, lookupProvider, blockTagGen, fileHelper));
        data.addProvider(includeServer, (DataProvider)new RecipeGen(output));
        data.addProvider(includeServer, (DataProvider)new EntityTypeTagGen(output, lookupProvider, fileHelper));
        data.addProvider(includeServer, (DataProvider)new LootTableGen(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BlockLoot::new, LootContextParamSets.f_81421_))));
        data.addProvider(includeServer, (DataProvider)new WorldGenGen(output, lookupProvider));
        data.addProvider(includeServer, (DataProvider)new ForgeAdvancementProvider(output, lookupProvider, fileHelper, List.of(new AdvancementGen())));
        data.addProvider(includeClient, (DataProvider)new BlockStateGen(output, fileHelper));
        data.addProvider(includeClient, (DataProvider)new ItemModelGen(output, fileHelper));
        if (includeClient) {
            int rows = 1100;
            String api = System.getenv("SWEM_TRANSLATION_API_KEY");
            URL url = new URL(String.format("https://sheets.googleapis.com/v4/spreadsheets/1nIuoznNlkud57_eE_piMSLIQAsQ9XRIiyzTBtwDC2kg/values/A66:AD%s?key=%s", rows, api));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            assert (con.getResponseCode() < 300);
            InputStreamReader targetReader = new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8);
            LanguageSheetData langData = (LanguageSheetData)new Gson().fromJson((Reader)targetReader, LanguageSheetData.class);
            DataGenerators.registerLanguageProviders(data, langData.getValues());
        }
    }

    private static void registerLanguageProviders(DataGenerator data, String[][] values) {
        PackOutput output = data.getPackOutput();
        data.addProvider(true, (DataProvider)new LanguageGen(output, "en_us", values, 2));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "da_dk", values, 3));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "nl_nl", values, 4));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "sv_se", values, 5));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "fr_fr", values, 6));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "pl_pl", values, 7));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "de_de", values, 8));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "ro_ro", values, 9));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "pt_br", values, 10));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "pt_pt", values, 11));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "it_it", values, 12));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "fi_fi", values, 13));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "ru_ru", values, 14));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "ja_jp", values, 16));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "sk_sk", values, 17));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "cs_cz", values, 18));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "hu_hu", values, 19));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "nn_no", values, 20));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "ga_ie", values, 21));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "et_ee", values, 22));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "zh_cn", values, 23));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "lt_lt", values, 24));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "tr_tr", values, 25));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "ko_kr", values, 26));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "af_za", values, 27));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "sr_sp", values, 28));
        data.addProvider(true, (DataProvider)new LanguageGen(output, "uk_ua", values, 29));
    }
}

