/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.data;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.data.HorseDataElement;
import com.alaharranhonor.swem.forge.data.HorseDataList;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.eventhandlers.CommonEventHandler;
import com.alaharranhonor.swem.forge.util.serializers.ComponentTypeAdapter;
import com.alaharranhonor.swem.forge.util.serializers.NbtTypeAdapter;
import com.alaharranhonor.swem.forge.util.serializers.ResourceLocationTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorseDataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"HorseDataManager");
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Component.class, (Object)new ComponentTypeAdapter().nullSafe()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocationTypeAdapter()).registerTypeAdapter(CompoundTag.class, (Object)new NbtTypeAdapter().nullSafe()).setLenient().setPrettyPrinting().create();
    private final Path dataPath;
    private HorseDataList horseDataList = new HorseDataList();

    public HorseDataManager(Path directory) {
        this.dataPath = directory.resolve("horseData.json");
    }

    private static HorseDataElement createDataFromHorse(SWEMHorseEntityBase horse) {
        HorseDataElement data = new HorseDataElement(horse.m_20148_());
        data.updateDataFromHorse(horse);
        return data;
    }

    public List<HorseDataElement> getHorsesBelongingTo(UUID playerId) {
        return this.horseDataList.allHorses().stream().filter(horse -> playerId.equals(horse.ownerId)).filter(horse -> !horse.isDead).collect(Collectors.toList());
    }

    @Nullable
    public HorseDataElement getHorseData(UUID horseId) {
        return this.horseDataList.getHorse(horseId);
    }

    public HorseDataElement getOrCreateHorseData(SWEMHorseEntityBase horse) {
        if (this.horseDataList.hasHorse(horse.m_20148_())) {
            return this.horseDataList.getHorse(horse.m_20148_());
        }
        HorseDataElement horseData = HorseDataManager.createDataFromHorse(horse);
        this.horseDataList.store(horse.m_20148_(), horseData);
        return horseData;
    }

    public void save(MinecraftServer server) {
        try {
            LOGGER.debug("Saving horse data to disk...");
            if (!Files.exists(this.dataPath, new LinkOption[0])) {
                LOGGER.info("Creating new horse data file.");
                Files.createDirectories(this.dataPath.getParent(), new FileAttribute[0]);
                Files.createFile(this.dataPath, new FileAttribute[0]);
            }
            this.updateAllData(server);
            Files.writeString(this.dataPath, (CharSequence)GSON.toJson((Object)this.horseDataList), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Could not save horse data to file.", (Throwable)e);
        }
    }

    private void updateAllData(MinecraftServer server) {
        for (HorseDataElement horseData : this.horseDataList.allHorses()) {
            Entity entity;
            ServerLevel level = server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)horseData.dimension));
            if (level == null || !((entity = level.m_8791_(horseData.horseId)) instanceof SWEMHorseEntityBase)) continue;
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            horseData.updateDataFromHorse(horse);
        }
    }

    public void load() throws IOException {
        LOGGER.info("Loading horse data...");
        if (!Files.exists(this.dataPath, new LinkOption[0])) {
            LOGGER.info("No horse data exists.");
            return;
        }
        this.horseDataList.loadFrom((HorseDataList)GSON.fromJson(Files.readString(this.dataPath), HorseDataList.class));
        LOGGER.info("Loaded {} horse data.", (Object)this.horseDataList.count());
    }

    public Collection<HorseDataElement> getAllData() {
        return this.horseDataList.allHorses();
    }

    @Mod.EventBusSubscriber(modid="swem")
    public static class EventHandler {
        @SubscribeEvent
        public static void saveData(LevelEvent.Save event) {
            ServerLevel level;
            LevelAccessor levelAccessor = event.getLevel();
            if (!(levelAccessor instanceof ServerLevel) || (level = (ServerLevel)levelAccessor).m_46472_() != Level.f_46428_) {
                return;
            }
            CommonEventHandler.getHorseDataManager().save(level.m_7654_());
        }

        @SubscribeEvent
        public static void loadData(LevelEvent.Load event) {
            ServerLevel level;
            LevelAccessor levelAccessor = event.getLevel();
            if (!(levelAccessor instanceof ServerLevel) || (level = (ServerLevel)levelAccessor).m_46472_() != Level.f_46428_) {
                return;
            }
            try {
                CommonEventHandler.getHorseDataManager().load();
            }
            catch (IOException e) {
                ModRef.LOGGER.error("Could not load horse data.", (Throwable)e);
            }
        }
    }
}

