/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.data;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.BreedingBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.LineageBehavior;
import com.alaharranhonor.swem.forge.util.InventoryUtil;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.phys.Vec3;

public class HorseDataElement {
    final UUID horseId;
    String horseName;
    UUID ownerId;
    String ownerName;
    ResourceLocation dimension;
    Vec3 position;
    boolean isDead;
    CompoundTag inventoryData;
    CompoundTag saddlebagData;
    CompoundTag progressionData;
    CompoundTag genderData;
    CompoundTag lineageData;

    public HorseDataElement(UUID horseId) {
        this.horseId = horseId;
    }

    public void updateDataFromHorse(SWEMHorseEntityBase horse) {
        if (horse.m_21805_() != null) {
            this.ownerId = horse.m_21805_();
            this.ownerName = horse.getOwnerName();
        }
        this.horseName = horse.m_7755_().getString();
        this.dimension = horse.m_9236_().m_46472_().m_135782_();
        this.position = horse.m_20182_();
        this.inventoryData = horse.saveInventory();
        if (horse.hasSaddleBag()) {
            this.saddlebagData = InventoryUtil.saveContainer((Container)horse.getSaddlebagInventory());
        }
        this.progressionData = new CompoundTag();
        horse.progressionManager.write(this.progressionData);
        BreedingBehavior breeding = horse.getBreeding();
        this.genderData = breeding.save(new CompoundTag());
        LineageBehavior lineage = horse.getBehavior(LineageBehavior.class);
        this.lineageData = lineage.save(new CompoundTag());
    }

    public void setDead() {
        this.isDead = true;
    }

    public String getName() {
        return this.horseName;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public UUID getHorseId() {
        return this.horseId;
    }

    public Vec3 getPosition() {
        return this.position;
    }
}

