/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.container;

import com.alaharranhonor.swem.forge.blocks.jumps.JumpLayer;
import com.alaharranhonor.swem.forge.blocks.jumps.StandardLayer;
import com.alaharranhonor.swem.forge.network.protocol.SWEMPackets;
import com.alaharranhonor.swem.forge.network.protocol.game.jumps.SDataSendPacket;
import com.alaharranhonor.swem.forge.registry.MenuSetup;
import com.alaharranhonor.swem.forge.tileentity.JumpBE;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.PacketDistributor;

public class JumpContainer
extends AbstractContainerMenu {
    public final JumpBE controller;
    public ServerPlayer player;
    public int layerAmount;
    public Map<Integer, JumpLayer> layerTypes = new HashMap<Integer, JumpLayer>();
    public Map<Integer, Integer> layerColors = new HashMap<Integer, Integer>();
    public StandardLayer currentStandard;

    public JumpContainer(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, JumpContainer.getTileEntity(playerInventory, data));
    }

    public JumpContainer(int id, Inventory playerInventory, JumpBE controller) {
        super((MenuType)MenuSetup.JUMP_CONTAINER.get(), id);
        this.controller = controller;
        if (!playerInventory.f_35978_.m_9236_().f_46443_) {
            this.player = (ServerPlayer)playerInventory.f_35978_;
        }
    }

    private static JumpBE getTileEntity(Inventory inventory, FriendlyByteBuf data) {
        if (inventory.f_35978_.m_9236_().f_46443_) {
            return null;
        }
        Objects.requireNonNull(inventory, "Inventory cannot be null");
        Objects.requireNonNull(data, "Packet Data cannot be null");
        BlockEntity tileAtPos = inventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof JumpBE) {
            return (JumpBE)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct." + tileAtPos);
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void m_38946_() {
        if (this.player == null) {
            return;
        }
        if (this.player.m_9236_().m_5776_()) {
            return;
        }
        if (this.layerAmount != this.controller.getLayerAmount()) {
            SWEMPackets.sendToPlayers(PacketDistributor.PLAYER.with(() -> this.player), new SDataSendPacket(this.controller.m_58899_(), this.controller.layerAmount, this.controller.layerTypes, this.controller.layerColors, this.controller.currentStandard));
            this.layerAmount = this.controller.layerAmount;
        }
        for (Map.Entry<Integer, JumpLayer> entry : this.controller.layerTypes.entrySet()) {
            if (this.layerTypes.entrySet().contains(entry)) continue;
            SWEMPackets.sendToPlayers(PacketDistributor.PLAYER.with(() -> this.player), new SDataSendPacket(this.controller.m_58899_(), this.controller.layerAmount, this.controller.layerTypes, this.controller.layerColors, this.controller.currentStandard));
            this.layerTypes.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : this.controller.layerColors.entrySet()) {
            if (this.layerColors.entrySet().contains(entry)) continue;
            SWEMPackets.sendToPlayers(PacketDistributor.PLAYER.with(() -> this.player), new SDataSendPacket(this.controller.m_58899_(), this.controller.layerAmount, this.controller.layerTypes, this.controller.layerColors, this.controller.currentStandard));
            this.layerColors.put(entry.getKey(), (Integer)entry.getValue());
        }
        if (this.currentStandard != this.controller.getCurrentStandard()) {
            SWEMPackets.sendToPlayers(PacketDistributor.PLAYER.with(() -> this.player), new SDataSendPacket(this.controller.m_58899_(), this.controller.layerAmount, this.controller.layerTypes, this.controller.layerColors, this.controller.currentStandard));
            this.currentStandard = this.controller.getCurrentStandard();
        }
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return ItemStack.f_41583_;
    }
}

