/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.config;

import com.alaharranhonor.swem.forge.config.HorseSpawnType;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="swem", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ServerConfig {
    public static ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.BooleanValue FOOD_NEED_ENABLED;
    public static ForgeConfigSpec.BooleanValue WATER_NEED_ENABLED;
    public static ForgeConfigSpec.BooleanValue POOP_NEED_ENABLED;
    public static ForgeConfigSpec.IntValue POOP_INTERVAL_IN_SECONDS;
    public static ForgeConfigSpec.BooleanValue PEE_NEED_ENABLED;
    public static ForgeConfigSpec.IntValue PEE_INTERVAL_IN_SECONDS;
    public static ForgeConfigSpec.IntValue FOAL_GROW_UP_TIME_IN_SECONDS;
    public static ForgeConfigSpec.IntValue INTAKE_SEARCH_RADIUS;
    public static ForgeConfigSpec.IntValue HEALTH_BOOSTER_TIME;
    public static ForgeConfigSpec.BooleanValue ENABLE_BREEDING_TOKENS;
    private static ForgeConfigSpec.BooleanValue PERMANENT_LOVE_MODE;
    private static ForgeConfigSpec.IntValue MARE_LOVE_TIME_IN_SECONDS;
    private static ForgeConfigSpec.IntValue STALLION_LOVE_TIME_IN_SECONDS;
    private static ForgeConfigSpec.IntValue MARE_GESTATION_TIME_IN_SECONDS;
    private static ForgeConfigSpec.IntValue STALLION_BREEDING_COOLDOWN_IN_SECONDS;
    private static ForgeConfigSpec.IntValue MARE_BREEDING_COOLDOWN_IN_SECONDS;
    private static ForgeConfigSpec.IntValue MAX_STALLION_COVERS;
    private static ForgeConfigSpec.IntValue MAX_MARE_BIRTHS;
    private static ForgeConfigSpec.IntValue TWIN_BIRTH_CHANCE;
    private static ForgeConfigSpec.BooleanValue REFERTILE_HORSE;
    private static ForgeConfigSpec.BooleanValue ENABLE_NATURAL_BREEDING;
    public static ForgeConfigSpec.BooleanValue EQUIP_BRIDLE_REQUIRED;
    public static ForgeConfigSpec.BooleanValue NEEDS_BRIDLE_TO_STEER;
    public static ForgeConfigSpec.BooleanValue EQUIP_BLANKET_REQUIRED;
    public static ForgeConfigSpec.BooleanValue EQUIP_SADDLE_REQUIRED;
    public static ForgeConfigSpec.BooleanValue EQUIP_GIRTH_STRAP_REQUIRED;
    public static ForgeConfigSpec.BooleanValue EQUIP_ALL_FOR_ARMOR;
    public static ForgeConfigSpec.IntValue TOTAL_SPEED_XP;
    public static ForgeConfigSpec.IntValue TOTAL_JUMP_XP;
    public static ForgeConfigSpec.IntValue TOTAL_HEALTH_XP;
    public static ForgeConfigSpec.IntValue TOTAL_AFFINITY_XP;
    public static ForgeConfigSpec.BooleanValue COAT_CYCLING_ENABLED;
    public static ForgeConfigSpec.BooleanValue VOID_TP;
    public static ForgeConfigSpec.BooleanValue ALLOW_SECRET_COATS;
    public static ForgeConfigSpec.BooleanValue SERVER_TIME;
    public static ForgeConfigSpec.IntValue SERVER_MORNING_HUNGY_TIME;
    public static ForgeConfigSpec.IntValue SERVER_EVENING_HUNGY_TIME;
    public static ForgeConfigSpec.BooleanValue REMOVE_XP_RENAME_COST;
    public static ForgeConfigSpec.BooleanValue DISABLE_AMETHYST_PERKS;
    public static ForgeConfigSpec.ConfigValue<List<String>> BLACKLISTED_COAT_IDS;
    public static ForgeConfigSpec.BooleanValue ENABLE_KEY_PERMISSIONS;
    public static ForgeConfigSpec.BooleanValue FIREWORK_DISPLAY;
    public static ForgeConfigSpec.BooleanValue WINGED_HORSE_FLY;
    private static ForgeConfigSpec.DoubleValue LIFESTEAL;
    private static ForgeConfigSpec.EnumValue<HorseSpawnType> HORSE_SPAWN;
    public static boolean enableAdvancedBreeding;
    public static boolean permanentLoveMode;
    public static int stallionLoveTimeInSeconds;
    public static int mareLoveTimeInSeconds;
    public static int mareGestationTimeInSeconds;
    public static int stallionBreedingCooldownInSeconds;
    public static int mareBreedingCooldownInSeconds;
    public static int maxStallionCovers;
    public static int maxMareBirths;
    public static int twinBirthChance;
    public static boolean refertileHorses;
    public static boolean enableNaturalBreeding;
    public static boolean wingedHorseFly;
    public static int serverMorningHungyTime;
    public static int serverEveningHungyTime;
    public static boolean enableKeyPermissions;
    public static HorseSpawnType horseSpawn;
    public static float lifesteal;
    public static boolean fireworkDisplay;

    public static void register(ForgeConfigSpec.Builder builder) {
        builder.comment(" || =========== [Horse Care] =========== ||").push("horse_care");
        FOOD_NEED_ENABLED = builder.comment(" || Do horses need to eat? (Default = True = Yes)").define("needFood", true);
        WATER_NEED_ENABLED = builder.comment(" || Do horses need to drink? (Default = True = Yes)").define("needWater", true);
        POOP_NEED_ENABLED = builder.comment(" || Enable Poop ticking on swem horses? (Default = True = Yes)").define("poopTick", true);
        INTAKE_SEARCH_RADIUS = builder.comment(new String[]{" || Specify range (radius) that the horses search for food/water. The larger the  radius, the more lag it can cause per horse.", " || We recommend \"15\" (30b diameter) for servers."}).defineInRange("intakeSearchRadius", 15, 5, 40);
        POOP_INTERVAL_IN_SECONDS = builder.comment(new String[]{" || Specify in seconds the interval between each poop cycle.", " || We recommend '1800' (30min) for singleplayer, and '2700' (45min) for multiplayer."}).defineInRange("poopInterval", 1800, 1, Integer.MAX_VALUE);
        PEE_NEED_ENABLED = builder.comment(" || Enable Pee ticking on swem horses? (Default = True = Yes)").define("peeTick", true);
        PEE_INTERVAL_IN_SECONDS = builder.comment(new String[]{" || Specify in seconds the interval between each pee cycle.", " || We recommend '1500' (25min) for singleplayer, and '2700' (45min) for multiplayer."}).defineInRange("peeInterval", 1500, 1, Integer.MAX_VALUE);
        FOAL_GROW_UP_TIME_IN_SECONDS = builder.comment(new String[]{" || Specify how many seconds it takes for the foal to growp up?", " || We recommend '1800' (30min) for singleplayer, and '28800' (8hr) for multiplayer."}).defineInRange("foalAgeInSeconds", 1800, 1, Integer.MAX_VALUE);
        HEALTH_BOOSTER_TIME = builder.comment(new String[]{" || Specify how many minutes the Health Booster lasts for?", " || We recommend '600' ~(30mc days) for singleplayer, and '10,000' ~(504mc days / 7irl days) for multiplayer."}).defineInRange("healthBoosterTime", 600, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.comment(" || =========== [Horse Breeding] =========== ||").push("horse_breeding");
        ENABLE_BREEDING_TOKENS = builder.comment(new String[]{" || Enable Breeding Tokens? This limits breeding of horses to Tokens, prevents feed from escalating foal growth time, and limits use of canatazarite potions.", " || Enable if the server is multiplayer and has an economy."}).define("tokensBreeding", false);
        PERMANENT_LOVE_MODE = builder.comment(new String[]{"\n || Do horses stay in love mode forever? (Default = False = No)", " || If false, horses will only be in love mode for the amount of seconds specified in stallionLoveTime and mareLoveTime."}).define("permanentLoveMode", false);
        STALLION_LOVE_TIME_IN_SECONDS = builder.comment(new String[]{"\n || Specify how many seconds the stallion stays in love mode (Only has an effect if permanentLoveMode is false).", " || We recommend '1800' (30min) for singleplayer, and '28800' (8hr) for multiplayer."}).defineInRange("stallionLoveTimeInSeconds", 1800, 1, Integer.MAX_VALUE);
        MARE_LOVE_TIME_IN_SECONDS = builder.comment(new String[]{"\n || Specify how many seconds the mare stays in love mode (Only has an effect if permanentLoveMode is false).", " || We recommend '1800' (30min) for singleplayer, and '28800' (8hr) for multiplayer."}).defineInRange("mareLoveTimeInSeconds", 1800, 1, Integer.MAX_VALUE);
        MARE_GESTATION_TIME_IN_SECONDS = builder.comment(new String[]{"\n || Specify how many seconds it takes for the mare to give birth", " || Set to 1 to disable gestation period, and making the birth instant.", " || We recommend '1800' (30min) for singleplayer, and '28800' (8hr) for multiplayer."}).defineInRange("mareGestationTimeInSeconds", 1800, 1, Integer.MAX_VALUE);
        STALLION_BREEDING_COOLDOWN_IN_SECONDS = builder.comment(new String[]{"\n || Specify how many seconds it takes for the stallion to be able to breed again.", " || We recommend '900' (15min) for singleplayer, and '14400' (4hr) for multiplayer."}).defineInRange("stallionBreedingCooldownInSeconds", 900, 1, Integer.MAX_VALUE);
        MARE_BREEDING_COOLDOWN_IN_SECONDS = builder.comment(new String[]{"\n || Specify how many seconds it takes for the mare to be able to breed again.", " || We recommend '1800' (30min) for singleplayer, and '28800' (8hr) for multiplayer."}).defineInRange("mareBreedingCooldownInSeconds", 1800, 1, Integer.MAX_VALUE);
        MAX_STALLION_COVERS = builder.comment(new String[]{"\n || Specify how many times a stallion can breed before it is infertile.", " || Disable infertility option by setting it to '0'."}).defineInRange("maxStallionCovers", 0, 0, Integer.MAX_VALUE);
        MAX_MARE_BIRTHS = builder.comment(new String[]{"\n || Specify how many times a mare can breed before it is infertile.", " || Disable infertility option by setting it to '0'."}).defineInRange("maxMareCovers", 0, 0, Integer.MAX_VALUE);
        TWIN_BIRTH_CHANCE = builder.comment(new String[]{"\n || Specify the chance of a mare giving birth to twins (Default = 1,000 = 0.1%)", " || If the value is higher than 1,000 the odds go down, if the value is lower than 1,000 the odds go up.", " || We recommend '1000' (1/1000 chance) for singleplayer, and '15000' (1/15000 chance) for multiplayer."}).defineInRange("twinBirthChance", 1000, 1, Integer.MAX_VALUE);
        REFERTILE_HORSE = builder.comment("\n || Should infertile horses be able to be made fertile again (by giving a male/female/random potion)?").define("refertile_horses", true);
        ENABLE_NATURAL_BREEDING = builder.comment("\n || If enabled, a Stallion will look for a fertile Mare to breed without need of items.").define("natural_breed_chance", false);
        builder.pop();
        builder.comment(" || =========== [Tack Dependencies] =========== ||").push("tack_dependencies");
        EQUIP_BRIDLE_REQUIRED = builder.comment(" || Is the Bridle slot required before equipping a Blanket? (Default = True = Yes)").define("needBridle", true);
        EQUIP_BLANKET_REQUIRED = builder.comment(" || Is the Blanket slot required before equipping a Saddle? (Default = True = Yes)").define("needBlanket", true);
        EQUIP_SADDLE_REQUIRED = builder.comment(" || Is the Saddle slot required before equipping the Girth Strap,  Breast Collar, and/or Saddlebag? (Default = True = Yes)").define("needSaddle", true);
        EQUIP_GIRTH_STRAP_REQUIRED = builder.comment(" || The Rider and Saddle should fall off if there is no Girth Strap equipped. (Default = True = Yes)").define("needGirthStrap", true);
        EQUIP_ALL_FOR_ARMOR = builder.comment(" || Are all Tack slots required before equipping Horse Armor? (Default = True = Yes)").define("needAll", true);
        NEEDS_BRIDLE_TO_STEER = builder.comment(" || The Bridle is needed to steer the horse. (If disabled, you would still need a saddle). (Default = True = Yes)").define("needBridleToSteer", true);
        builder.pop();
        builder.comment(" || =========== [Horse Experience Levels] =========== ||").push("horse_experience_levels");
        TOTAL_SPEED_XP = builder.comment(new String[]{" || Amount of XP required to max a horse's Speed stat.", " || We recommend '13500' for singleplayer, and '100000' for multiplayer."}).defineInRange("maxSpeedXP", 13500, 1, Integer.MAX_VALUE);
        TOTAL_JUMP_XP = builder.comment(new String[]{" || Amount of XP required to max a horse's Jump stat.", " || We recommend '13500' for singleplayer, and '100000' for multiplayer."}).defineInRange("maxJumpXP", 13500, 1, Integer.MAX_VALUE);
        TOTAL_HEALTH_XP = builder.comment(new String[]{" || Amount of XP required to max a horse's Health  stat.", " || We recommend '13500' for singleplayer, and '100000' for multiplayer."}).defineInRange("maxHealthXP", 13500, 1, Integer.MAX_VALUE);
        TOTAL_AFFINITY_XP = builder.comment(new String[]{" || Amount of XP required to max a horse's Affinity stat.", " || We recommend '17000' for singleplayer, and '50000' for multiplayer."}).defineInRange("maxAffinityXP", 17000, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.comment(" || =========== [Server Admin] =========== ||").push("server_admin");
        COAT_CYCLING_ENABLED = builder.comment(new String[]{" || Enable Coat Cycling (via lapis lazuli and redstone)?", " || Do not enable if the server is multiplayer and has an economy."}).define("allowCoatCycling", true);
        ALLOW_SECRET_COATS = builder.comment(new String[]{" || Can Secret Coats be obtained via Secret Items? (Default = True = Yes)", " || Do not enable if the server is multiplayer and has an economy."}).define("allowSecretCoats", true);
        SERVER_TIME = builder.comment(new String[]{" || Enable the horse's food/water systems to be based off the 24 hour day?", " || This is recommended for servers ONLY."}).define("serverTime", false);
        SERVER_MORNING_HUNGY_TIME = builder.comment(new String[]{" || Required only is 'serverTime' config is enabled.", " || The hour at which morning hungy time triggers (Local to the server)."}).defineInRange("morningHungyTime", 7, 0, 23);
        SERVER_EVENING_HUNGY_TIME = builder.comment(new String[]{" || Required only is 'serverTime' config is enabled.", " || The hour at which evening hungy time triggers (Local to the server)."}).defineInRange("eveningHungyTime", 20, 0, 23);
        REMOVE_XP_RENAME_COST = builder.comment(" || Should xp cost for renaming items in an cantazarite anvil be removed?").define("removeXpRenameCost", true);
        DISABLE_AMETHYST_PERKS = builder.comment(" || Should the perks provided by the Amethyst Armor (excluding Amethyst Riding Boots) be disabled?").define("disableAmethystPerks", false);
        VOID_TP = builder.comment(" || Should the rider be teleported with the horse if the horse should fall into the void whilst the horse is wearing Amethyst Tier Armor.").define("voidTP", true);
        BLACKLISTED_COAT_IDS = builder.comment(new String[]{" || List of coats ids that should not be obtainable", " || Example: [\"swem:salamarty_arishant_cytris\", \"swem:mr_ed\", \"swem:joey_this_esme\", \"swem:delta_malli\"]"}).defineList("blacklistedCoatIds", new ArrayList(), o -> o instanceof String);
        ENABLE_KEY_PERMISSIONS = builder.comment(new String[]{" || Enable SWEM's built-in permission node system for controlling player use of commands.", " || This is recommended for servers ONLY."}).define("enableKeyPermission", false);
        HORSE_SPAWN = builder.comment(" || What horses should spawn? Vanilla horses only, SWEM horses only, or Both?").defineEnum("horseSpawn", (Enum)HorseSpawnType.BOTH);
        FIREWORK_DISPLAY = builder.comment(" || Enables fireworks to be shot out of jumps and barrels when horses touch them.").define("fireworkDisplay", false);
        WINGED_HORSE_FLY = builder.comment(" || Should winged horse fly without requirement of Amethyst Horse Armor?").define("wingedHorseFly", true);
        LIFESTEAL = builder.comment("|| How much to heal the player wearing Netherite+ Riding Boots as a percentage of damage dealt.").defineInRange("lifesteal", 0.05, 0.01, 1.0);
        builder.pop();
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent event) {
        if (!"swem".equals(event.getConfig().getModId()) || event.getConfig().getType() != ModConfig.Type.SERVER) {
            return;
        }
        permanentLoveMode = (Boolean)PERMANENT_LOVE_MODE.get();
        stallionLoveTimeInSeconds = (Integer)STALLION_LOVE_TIME_IN_SECONDS.get();
        mareLoveTimeInSeconds = (Integer)MARE_LOVE_TIME_IN_SECONDS.get();
        mareGestationTimeInSeconds = (Integer)MARE_GESTATION_TIME_IN_SECONDS.get();
        mareBreedingCooldownInSeconds = (Integer)MARE_BREEDING_COOLDOWN_IN_SECONDS.get();
        stallionBreedingCooldownInSeconds = (Integer)STALLION_BREEDING_COOLDOWN_IN_SECONDS.get();
        maxStallionCovers = (Integer)MAX_STALLION_COVERS.get();
        maxMareBirths = (Integer)MAX_MARE_BIRTHS.get();
        twinBirthChance = (Integer)TWIN_BIRTH_CHANCE.get();
        refertileHorses = (Boolean)REFERTILE_HORSE.get();
        enableNaturalBreeding = (Boolean)ENABLE_NATURAL_BREEDING.get();
        enableKeyPermissions = (Boolean)ENABLE_KEY_PERMISSIONS.get();
        fireworkDisplay = (Boolean)FIREWORK_DISPLAY.get();
        horseSpawn = (HorseSpawnType)((Object)HORSE_SPAWN.get());
        wingedHorseFly = (Boolean)WINGED_HORSE_FLY.get();
        lifesteal = ((Double)LIFESTEAL.get()).floatValue();
        serverMorningHungyTime = (Integer)SERVER_MORNING_HUNGY_TIME.get();
        serverEveningHungyTime = (Integer)SERVER_EVENING_HUNGY_TIME.get();
    }

    public static void setSpec(ForgeConfigSpec spec) {
        SPEC = spec;
    }
}

