/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.config;

import com.alaharranhonor.swem.forge.config.ClientConfig;
import com.alaharranhonor.swem.forge.config.CommonConfig;
import com.alaharranhonor.swem.forge.config.KeysConfig;
import com.alaharranhonor.swem.forge.config.RecipeControlConfig;
import com.alaharranhonor.swem.forge.config.ServerConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class Config {
    public static void register() {
        Config.registerServerConfigs();
        Config.registerCommonConfigs();
        Config.registerItemConfigs();
        Config.registerClientConfigs();
    }

    private static void registerClientConfigs() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        ClientConfig.register(builder);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)builder.build(), "swem/swem-client.toml");
    }

    private static void registerCommonConfigs() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        CommonConfig.register(builder);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)builder.build(), "swem/swem-common.toml");
    }

    private static void registerItemConfigs() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        RecipeControlConfig.register(builder);
        ForgeConfigSpec spec = builder.build();
        RecipeControlConfig.setSpec(spec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)spec, "swem/swem-recipe-control.toml");
    }

    private static void registerServerConfigs() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        ServerConfig.register(builder);
        ForgeConfigSpec spec = builder.build();
        ServerConfig.setSpec(spec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)spec);
    }

    private static void registerKeyConfigs() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        KeysConfig.register(builder);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)builder.build(), "swem-perm-keys.toml");
    }
}

